/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.stat;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.stat.StatisticalRule;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.Metric;

public class StatisticalRuleHelper {
    public static final double DELTA = 5.0E-6;
    private AbstractRule rule;
    private SortedSet<DataPoint> dataPoints = new TreeSet<DataPoint>();
    private int count = 0;
    private double total = 0.0;

    public StatisticalRuleHelper(AbstractRule rule) {
        this.rule = rule;
        rule.definePropertyDescriptor(StatisticalRule.SIGMA_DESCRIPTOR);
        rule.definePropertyDescriptor(StatisticalRule.MINIMUM_DESCRIPTOR);
        rule.definePropertyDescriptor(StatisticalRule.TOP_SCORE_DESCRIPTOR);
    }

    public void addDataPoint(DataPoint point) {
        ++this.count;
        this.total += point.getScore();
        this.dataPoints.add(point);
    }

    public void apply(RuleContext ctx) {
        double mMin;
        double minimum = 0.0;
        if (this.rule.getProperty(StatisticalRule.SIGMA_DESCRIPTOR) != null) {
            double deviation = this.getStdDev();
            double sigma = this.rule.getProperty(StatisticalRule.SIGMA_DESCRIPTOR);
            minimum = this.getMean() + sigma * deviation;
        }
        if (this.rule.getProperty(StatisticalRule.MINIMUM_DESCRIPTOR) != null && (mMin = this.rule.getProperty(StatisticalRule.MINIMUM_DESCRIPTOR).doubleValue()) > minimum) {
            minimum = mMin;
        }
        SortedSet<DataPoint> newPoints = this.applyMinimumValue(this.dataPoints, minimum);
        if (this.rule.getProperty(StatisticalRule.TOP_SCORE_DESCRIPTOR) != null) {
            int topScore = this.rule.getProperty(StatisticalRule.TOP_SCORE_DESCRIPTOR);
            if (newPoints.size() >= topScore) {
                newPoints = this.applyTopScore(newPoints, topScore);
            }
        }
        this.makeViolations(ctx, newPoints);
        double low = 0.0;
        double high = 0.0;
        if (!this.dataPoints.isEmpty()) {
            low = this.dataPoints.first().getScore();
            high = this.dataPoints.last().getScore();
        }
        ctx.getReport().addMetric(new Metric(this.rule.getName(), this.count, this.total, low, high, this.getMean(), this.getStdDev()));
        this.dataPoints.clear();
    }

    private double getMean() {
        return this.total / (double)this.count;
    }

    private double getStdDev() {
        if (this.dataPoints.size() < 2) {
            return Double.NaN;
        }
        double mean = this.getMean();
        double deltaSq = 0.0;
        for (DataPoint point : this.dataPoints) {
            double scoreMinusMean = point.getScore() - mean;
            deltaSq += scoreMinusMean * scoreMinusMean;
        }
        return Math.sqrt(deltaSq / (double)(this.dataPoints.size() - 1));
    }

    private SortedSet<DataPoint> applyMinimumValue(SortedSet<DataPoint> pointSet, double minValue) {
        TreeSet<DataPoint> rc = new TreeSet<DataPoint>();
        double threshold = minValue - 5.0E-6;
        for (DataPoint point : pointSet) {
            if (!(point.getScore() > threshold)) continue;
            rc.add(point);
        }
        return rc;
    }

    private SortedSet<DataPoint> applyTopScore(SortedSet<DataPoint> points, int topScore) {
        TreeSet<DataPoint> s = new TreeSet<DataPoint>();
        DataPoint[] arr = points.toArray(new DataPoint[0]);
        for (int i = arr.length - 1; i >= arr.length - topScore; --i) {
            s.add(arr[i]);
        }
        return s;
    }

    private void makeViolations(RuleContext ctx, Set<DataPoint> p) {
        for (DataPoint point : p) {
            this.rule.addViolationWithMessage(ctx, point.getNode(), point.getMessage(), ((StatisticalRule)((Object)this.rule)).getViolationParameters(point));
        }
    }
}

