/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class SimpleRenderer
implements Renderer {
    private String separator;
    private boolean trimLeadingWhitespace;
    public static final String DEFAULT_SEPARATOR = "=====================================================================";

    public SimpleRenderer() {
        this(false);
    }

    public SimpleRenderer(boolean trimLeadingWhitespace) {
        this(DEFAULT_SEPARATOR);
        this.trimLeadingWhitespace = trimLeadingWhitespace;
    }

    public SimpleRenderer(String theSeparator) {
        this.separator = theSeparator;
    }

    private void renderOn(StringBuilder rpt, Match match) {
        rpt.append("Found a ").append(match.getLineCount()).append(" line (").append(match.getTokenCount()).append(" tokens) duplication in the following files: ").append(PMD.EOL);
        for (Mark mark : match) {
            rpt.append("Starting at line ").append(mark.getBeginLine()).append(" of ").append(mark.getFilename()).append(PMD.EOL);
        }
        rpt.append(PMD.EOL);
        String source = match.getSourceCodeSlice();
        if (this.trimLeadingWhitespace) {
            String[] lines = source.split("[" + PMD.EOL + "]");
            int trimDepth = StringUtil.maxCommonLeadingWhitespaceForAll(lines);
            if (trimDepth > 0) {
                lines = StringUtil.trimStartOn(lines, trimDepth);
            }
            for (int i = 0; i < lines.length; ++i) {
                rpt.append(lines[i]).append(PMD.EOL);
            }
            return;
        }
        rpt.append(source).append(PMD.EOL);
    }

    @Override
    public String render(Iterator<Match> matches) {
        StringBuilder rpt = new StringBuilder(300);
        if (matches.hasNext()) {
            this.renderOn(rpt, matches.next());
        }
        while (matches.hasNext()) {
            Match match = matches.next();
            rpt.append(this.separator).append(PMD.EOL);
            this.renderOn(rpt, match);
        }
        return rpt.toString();
    }
}

