/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.List;
import java.util.WeakHashMap;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTModifierNode;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexSharingViolationsRule
extends AbstractApexRule {
    private WeakHashMap<ApexNode<?>, Object> localCacheOfReportedNodes = new WeakHashMap();

    public ApexSharingViolationsRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        if (!Helper.isTestMethodOrClass(node)) {
            boolean sharingFound = this.isSharingPresent(node);
            this.checkForSharingDeclaration(node, data, sharingFound);
            this.checkForDatabaseMethods(node, data, sharingFound);
        }
        this.localCacheOfReportedNodes.clear();
        return data;
    }

    private void checkForDatabaseMethods(ASTUserClass node, Object data, boolean sharingFound) {
        List calls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression call : calls) {
            if (!Helper.isMethodName(call, "Database", "*") || sharingFound) continue;
            this.reportViolation(node, data);
        }
    }

    private void reportViolation(ApexNode<?> node, Object data) {
        ASTModifierNode modifier = (ASTModifierNode)node.getFirstChildOfType(ASTModifierNode.class);
        if (modifier != null) {
            if (this.localCacheOfReportedNodes.put(modifier, data) == null) {
                this.addViolation(data, modifier);
            }
        } else if (this.localCacheOfReportedNodes.put(node, data) == null) {
            this.addViolation(data, node);
        }
    }

    private void checkForSharingDeclaration(ApexNode<?> node, Object data, boolean sharingFound) {
        boolean foundAnyDMLorSOQL;
        boolean bl = foundAnyDMLorSOQL = Helper.foundAnyDML(node) || Helper.foundAnySOQLorSOSL(node);
        if (!sharingFound && !Helper.isTestMethodOrClass(node) && foundAnyDMLorSOQL) {
            this.reportViolation(node, data);
        }
    }

    private boolean isSharingPresent(ASTUserClass node) {
        return node.getModifiers().isWithoutSharing() || node.getModifiers().isWithSharing() || node.getModifiers().isInheritedSharing();
    }
}

