/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTNewObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexOpenRedirectRule
extends AbstractApexRule {
    private static final String PAGEREFERENCE = "PageReference";
    private final Set<String> listOfStringLiteralVariables = new HashSet<String>();

    public ApexOpenRedirectRule() {
        super.addRuleChainVisit(ASTUserClass.class);
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        List assignmentExprs = node.findDescendantsOfType(ASTAssignmentExpression.class);
        for (Object assignment : assignmentExprs) {
            this.findSafeLiterals((ApexNode<?>)assignment);
        }
        List variableDecls = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (Object varDecl : variableDecls) {
            this.findSafeLiterals((ApexNode<?>)varDecl);
        }
        List fieldDecl = node.findDescendantsOfType(ASTField.class);
        for (ASTField fDecl : fieldDecl) {
            this.findSafeLiterals(fDecl);
        }
        List newObjects = node.findDescendantsOfType(ASTNewObjectExpression.class);
        for (ASTNewObjectExpression newObj : newObjects) {
            this.checkNewObjects(newObj, data);
        }
        this.listOfStringLiteralVariables.clear();
        return data;
    }

    private void findSafeLiterals(ApexNode<?> node) {
        ASTField field;
        ASTLiteralExpression literal;
        ASTBinaryExpression binaryExp = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (binaryExp != null) {
            this.findSafeLiterals(binaryExp);
        }
        if ((literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class)) != null) {
            int index = literal.getIndexInParent();
            if (index == 0) {
                if (node instanceof ASTVariableDeclaration) {
                    this.addVariable((ASTVariableDeclaration)node);
                } else if (node instanceof ASTBinaryExpression) {
                    ASTVariableExpression var;
                    ASTAssignmentExpression assignment;
                    ASTVariableDeclaration parent = (ASTVariableDeclaration)node.getFirstParentOfType(ASTVariableDeclaration.class);
                    if (parent != null) {
                        this.addVariable(parent);
                    }
                    if ((assignment = (ASTAssignmentExpression)node.getFirstParentOfType(ASTAssignmentExpression.class)) != null && (var = (ASTVariableExpression)assignment.getFirstChildOfType(ASTVariableExpression.class)) != null) {
                        this.addVariable(var);
                    }
                }
            }
        } else if (node instanceof ASTField && "String".equalsIgnoreCase((field = (ASTField)node).getType()) && field.getValue() != null) {
            this.listOfStringLiteralVariables.add(Helper.getFQVariableName(field));
        }
    }

    private void addVariable(ASTVariableDeclaration node) {
        ASTVariableExpression variable = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        this.addVariable(variable);
    }

    private void addVariable(ASTVariableExpression node) {
        if (node != null) {
            this.listOfStringLiteralVariables.add(Helper.getFQVariableName(node));
        }
    }

    private void checkNewObjects(ASTNewObjectExpression node, Object data) {
        ASTMethod method = (ASTMethod)node.getFirstParentOfType(ASTMethod.class);
        if (method != null && Helper.isTestMethodOrClass(method)) {
            return;
        }
        if (node.getType().equalsIgnoreCase(PAGEREFERENCE)) {
            this.getObjectValue(node, data);
        }
    }

    private void getObjectValue(ApexNode<?> node, Object data) {
        List variableExpressions = node.findChildrenOfType(ASTVariableExpression.class);
        for (ASTVariableExpression variable : variableExpressions) {
            if (variable.getIndexInParent() != 0 || this.listOfStringLiteralVariables.contains(Helper.getFQVariableName(variable))) continue;
            this.addViolation(data, variable);
        }
        List binaryExpressions = node.findChildrenOfType(ASTBinaryExpression.class);
        for (ASTBinaryExpression z : binaryExpressions) {
            this.getObjectValue(z, data);
        }
    }
}

