/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.performance;

import net.sourceforge.pmd.lang.apex.ast.ASTDoLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForEachStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTSoslExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTWhileLoopStatement;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class AvoidSoslInLoopsRule
extends AbstractApexRule {
    public AvoidSoslInLoopsRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Performance"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 150);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTSoslExpression node, Object data) {
        if (this.insideLoop(node) && this.parentNotReturn(node) && this.parentNotForEach(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean parentNotReturn(ASTSoslExpression node) {
        return !(node.getParent() instanceof ASTReturnStatement);
    }

    private boolean parentNotForEach(ASTSoslExpression node) {
        return !(node.getParent() instanceof ASTForEachStatement);
    }

    private boolean insideLoop(ASTSoslExpression node) {
        for (Node n = node.getParent(); n != null; n = n.getParent()) {
            if (!(n instanceof ASTDoLoopStatement) && !(n instanceof ASTWhileLoopStatement) && !(n instanceof ASTForLoopStatement) && !(n instanceof ASTForEachStatement)) continue;
            return true;
        }
        return false;
    }
}

