/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.performance;

import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTDoLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForEachStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTWhileLoopStatement;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class AvoidSoqlInLoopsRule
extends AbstractApexRule {
    public AvoidSoqlInLoopsRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Performance"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 150);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTSoqlExpression node, Object data) {
        if (this.insideLoop(node) && this.parentNotReturn(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean parentNotReturn(ASTSoqlExpression node) {
        return !(node.getParent() instanceof ASTReturnStatement);
    }

    private boolean insideLoop(ASTSoqlExpression node) {
        for (Node n = node.getParent(); n != null; n = n.getParent()) {
            if (n instanceof ASTBlockStatement && n.getParent() instanceof ASTForEachStatement) {
                return true;
            }
            if (!(n instanceof ASTDoLoopStatement) && !(n instanceof ASTWhileLoopStatement) && !(n instanceof ASTForLoopStatement)) continue;
            return true;
        }
        return false;
    }
}

