/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.style;

import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTParameter;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTUserInterface;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.StringMultiProperty;
import net.sourceforge.pmd.util.CollectionUtil;

public class VariableNamingConventionsRule
extends AbstractApexRule {
    private boolean checkMembers;
    private boolean checkLocals;
    private boolean checkParameters;
    private String[] staticPrefixes;
    private String[] staticSuffixes;
    private String[] memberPrefixes;
    private String[] memberSuffixes;
    private String[] localPrefixes;
    private String[] localSuffixes;
    private String[] parameterPrefixes;
    private String[] parameterSuffixes;
    private static final BooleanProperty CHECK_MEMBERS_DESCRIPTOR = new BooleanProperty("checkMembers", "Check member variables", Boolean.valueOf(true), 1.0f);
    private static final BooleanProperty CHECK_LOCALS_DESCRIPTOR = new BooleanProperty("checkLocals", "Check local variables", Boolean.valueOf(true), 2.0f);
    private static final BooleanProperty CHECK_PARAMETERS_DESCRIPTOR = new BooleanProperty("checkParameters", "Check constructor and method parameter variables", Boolean.valueOf(true), 3.0f);
    private static final StringMultiProperty STATIC_PREFIXES_DESCRIPTOR = new StringMultiProperty("staticPrefix", "Static variable prefixes", new String[]{""}, 4.0f, ',');
    private static final StringMultiProperty STATIC_SUFFIXES_DESCRIPTOR = new StringMultiProperty("staticSuffix", "Static variable suffixes", new String[]{""}, 5.0f, ',');
    private static final StringMultiProperty MEMBER_PREFIXES_DESCRIPTOR = new StringMultiProperty("memberPrefix", "Member variable prefixes", new String[]{""}, 6.0f, ',');
    private static final StringMultiProperty MEMBER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("memberSuffix", "Member variable suffixes", new String[]{""}, 7.0f, ',');
    private static final StringMultiProperty LOCAL_PREFIXES_DESCRIPTOR = new StringMultiProperty("localPrefix", "Local variable prefixes", new String[]{""}, 8.0f, ',');
    private static final StringMultiProperty LOCAL_SUFFIXES_DESCRIPTOR = new StringMultiProperty("localSuffix", "Local variable suffixes", new String[]{""}, 9.0f, ',');
    private static final StringMultiProperty PARAMETER_PREFIXES_DESCRIPTOR = new StringMultiProperty("parameterPrefix", "Method parameter variable prefixes", new String[]{""}, 10.0f, ',');
    private static final StringMultiProperty PARAMETER_SUFFIXES_DESCRIPTOR = new StringMultiProperty("parameterSuffix", "Method parameter variable suffixes", new String[]{""}, 11.0f, ',');

    public VariableNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_MEMBERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_LOCALS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_PARAMETERS_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)STATIC_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MEMBER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)MEMBER_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)LOCAL_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)LOCAL_SUFFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PARAMETER_PREFIXES_DESCRIPTOR);
        this.definePropertyDescriptor((PropertyDescriptor)PARAMETER_SUFFIXES_DESCRIPTOR);
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Style"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 5);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTUserInterface node, Object data) {
        this.init();
        return super.visit(node, data);
    }

    protected void init() {
        this.checkMembers = (Boolean)this.getProperty((PropertyDescriptor)CHECK_MEMBERS_DESCRIPTOR);
        this.checkLocals = (Boolean)this.getProperty((PropertyDescriptor)CHECK_LOCALS_DESCRIPTOR);
        this.checkParameters = (Boolean)this.getProperty((PropertyDescriptor)CHECK_PARAMETERS_DESCRIPTOR);
        this.staticPrefixes = (String[])this.getProperty((PropertyDescriptor)STATIC_PREFIXES_DESCRIPTOR);
        this.staticSuffixes = (String[])this.getProperty((PropertyDescriptor)STATIC_SUFFIXES_DESCRIPTOR);
        this.memberPrefixes = (String[])this.getProperty((PropertyDescriptor)MEMBER_PREFIXES_DESCRIPTOR);
        this.memberSuffixes = (String[])this.getProperty((PropertyDescriptor)MEMBER_SUFFIXES_DESCRIPTOR);
        this.localPrefixes = (String[])this.getProperty((PropertyDescriptor)LOCAL_PREFIXES_DESCRIPTOR);
        this.localSuffixes = (String[])this.getProperty((PropertyDescriptor)LOCAL_SUFFIXES_DESCRIPTOR);
        this.parameterPrefixes = (String[])this.getProperty((PropertyDescriptor)PARAMETER_PREFIXES_DESCRIPTOR);
        this.parameterSuffixes = (String[])this.getProperty((PropertyDescriptor)PARAMETER_SUFFIXES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTField node, Object data) {
        if (!this.checkMembers) {
            return data;
        }
        boolean isStatic = ((Field)node.getNode()).getFieldInfo().getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.STATIC);
        boolean isFinal = ((Field)node.getNode()).getFieldInfo().getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.FINAL);
        return this.checkName(isStatic ? this.staticPrefixes : this.memberPrefixes, isStatic ? this.staticSuffixes : this.memberSuffixes, node, isStatic, isFinal, data);
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        if (!this.checkLocals) {
            return data;
        }
        boolean isFinal = ((VariableDeclaration)node.getNode()).getLocalInfo().getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.FINAL);
        return this.checkName(this.localPrefixes, this.localSuffixes, node, false, isFinal, data);
    }

    @Override
    public Object visit(ASTParameter node, Object data) {
        if (!this.checkParameters) {
            return data;
        }
        boolean isFinal = ((Parameter)node.getNode()).getModifierInfo().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.FINAL);
        return this.checkName(this.parameterPrefixes, this.parameterSuffixes, node, false, isFinal, data);
    }

    private Object checkName(String[] prefixes, String[] suffixes, ApexNode<?> node, boolean isStatic, boolean isFinal, Object data) {
        String varName = node.getImage();
        if (varName == null || varName.equals("serialVersionUID")) {
            return data;
        }
        if (isStatic && isFinal) {
            if (!varName.equals(varName.toUpperCase())) {
                this.addViolationWithMessage(data, node, "Variables that are final and static should be all capitals, ''{0}'' is not all capitals.", new Object[]{varName});
            }
            return data;
        }
        if (!isFinal) {
            String normalizedVarName = this.normalizeVariableName(varName, prefixes, suffixes);
            if (normalizedVarName.indexOf(95) >= 0) {
                this.addViolationWithMessage(data, node, "Only variables that are final should contain underscores (except for underscores in standard prefix/suffix), ''{0}'' is not final.", new Object[]{varName});
            }
            if (Character.isUpperCase(varName.charAt(0))) {
                this.addViolationWithMessage(data, node, "Variables should start with a lowercase character, ''{0}'' starts with uppercase character.", new Object[]{varName});
            }
        }
        return data;
    }

    private String normalizeVariableName(String varName, String[] prefixes, String[] suffixes) {
        return this.stripSuffix(this.stripPrefix(varName, prefixes), suffixes);
    }

    private String stripSuffix(String varName, String[] suffixes) {
        if (suffixes != null) {
            for (int i = 0; i < suffixes.length; ++i) {
                if (!varName.endsWith(suffixes[i])) continue;
                varName = varName.substring(0, varName.length() - suffixes[i].length());
                break;
            }
        }
        return varName;
    }

    private String stripPrefix(String varName, String[] prefixes) {
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                if (!varName.startsWith(prefixes[i])) continue;
                return varName.substring(prefixes[i].length());
            }
        }
        return varName;
    }

    public boolean hasPrefixesOrSuffixes() {
        for (PropertyDescriptor desc : this.getPropertyDescriptors()) {
            Object[] values;
            if (!(desc instanceof StringMultiProperty) || !CollectionUtil.isNotEmpty((Object[])(values = (String[])this.getProperty((PropertyDescriptor)((StringMultiProperty)desc))))) continue;
            return true;
        }
        return false;
    }

    public String dysfunctionReason() {
        return this.hasPrefixesOrSuffixes() ? null : "No prefixes or suffixes specified";
    }
}

