/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.style;

import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTProperty;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;

public class MethodNamingConventionsRule
extends AbstractApexRule {
    public MethodNamingConventionsRule() {
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Style"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 1);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (this.isOverriddenMethod(node) || this.isPropertyAccessor(node) || this.isConstructor(node)) {
            return data;
        }
        String methodName = node.getImage();
        if (Character.isUpperCase(methodName.charAt(0))) {
            this.addViolationWithMessage(data, node, "Method names should not start with capital letters");
        }
        if (methodName.indexOf(95) >= 0) {
            this.addViolationWithMessage(data, node, "Method names should not contain underscores");
        }
        return data;
    }

    private boolean isOverriddenMethod(ASTMethod node) {
        return ((Method)node.getNode()).getModifiers().has((ModifierOrAnnotationTypeInfo)ModifierTypeInfos.OVERRIDE);
    }

    private boolean isPropertyAccessor(ASTMethod node) {
        return node.getParentsOfType(ASTProperty.class).size() > 0;
    }

    private boolean isConstructor(ASTMethod node) {
        return ((Method)node.getNode()).getMethodInfo().isConstructor();
    }
}

