/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;
import net.sourceforge.pmd.lang.ast.Node;

public class ApexXSSFromURLParamRule
extends AbstractApexRule {
    private static final String[] URL_PARAMETER_METHOD = new String[]{"ApexPages", "currentPage", "getParameters", "get"};
    private static final String[] HTML_ESCAPING = new String[]{"ESAPI", "encoder", "SFDC_HTMLENCODE"};
    private static final String[] JS_ESCAPING = new String[]{"ESAPI", "encoder", "SFDC_JSENCODE"};
    private static final String[] JSINHTML_ESCAPING = new String[]{"ESAPI", "encoder", "SFDC_JSINHTMLENCODE"};
    private static final String[] URL_ESCAPING = new String[]{"ESAPI", "encoder", "SFDC_URLENCODE"};
    private static final String[] STRING_HTML3 = new String[]{"String", "escapeHtml3"};
    private static final String[] STRING_HTML4 = new String[]{"String", "escapeHtml4"};
    private static final String[] STRING_XML = new String[]{"String", "escapeXml"};
    private static final String[] STRING_ECMASCRIPT = new String[]{"String", "escapeEcmaScript"};
    private static final String[] INTEGER_VALUEOF = new String[]{"Integer", "valueOf"};
    private static final String[] ID_VALUEOF = new String[]{"ID", "valueOf"};
    private static final String[] DOUBLE_VALUEOF = new String[]{"Double", "valueOf"};
    private static final String[] BOOLEAN_VALUEOF = new String[]{"Boolean", "valueOf"};
    private static final String[] STRING_ISEMPTY = new String[]{"String", "isEmpty"};
    private static final String[] STRING_ISBLANK = new String[]{"String", "isBlank"};
    private static final String[] STRING_ISNOTBLANK = new String[]{"String", "isNotBlank"};
    private final Set<String> urlParameterStrings = new HashSet<String>();

    public ApexXSSFromURLParamRule() {
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 50);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTAssignmentExpression node, Object data) {
        this.findTaintedVariables(node, data);
        this.processVariableAssignments(node, data, false);
        return data;
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        this.findTaintedVariables(node, data);
        this.processVariableAssignments(node, data, true);
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        this.findTaintedVariables(node, data);
        this.processVariableAssignments(node, data, true);
        return data;
    }

    @Override
    public Object visit(ASTMethodCallExpression node, Object data) {
        this.processEscapingMethodCalls(node, data);
        this.processInlineMethodCalls(node, data, false);
        return data;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        ASTMethodCallExpression methodCall;
        ASTBinaryExpression binaryExpression = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (binaryExpression != null) {
            this.processBinaryExpression(binaryExpression, data);
        }
        if ((methodCall = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class)) != null) {
            this.processInlineMethodCalls(methodCall, data, true);
        }
        List nodes = node.findChildrenOfType(ASTVariableExpression.class);
        for (ASTVariableExpression varExpression : nodes) {
            if (!this.urlParameterStrings.contains(Helper.getFQVariableName(varExpression))) continue;
            this.addViolation(data, (Node)nodes.get(0));
        }
        return data;
    }

    private boolean isEscapingMethod(ASTMethodCallExpression methodNode) {
        return Helper.isMethodCallChain(methodNode, HTML_ESCAPING) || Helper.isMethodCallChain(methodNode, JS_ESCAPING) || Helper.isMethodCallChain(methodNode, JSINHTML_ESCAPING) || Helper.isMethodCallChain(methodNode, URL_ESCAPING) || Helper.isMethodCallChain(methodNode, STRING_HTML3) || Helper.isMethodCallChain(methodNode, STRING_HTML4) || Helper.isMethodCallChain(methodNode, STRING_XML) || Helper.isMethodCallChain(methodNode, STRING_ECMASCRIPT) || Helper.isMethodCallChain(methodNode, INTEGER_VALUEOF) || Helper.isMethodCallChain(methodNode, DOUBLE_VALUEOF) || Helper.isMethodCallChain(methodNode, BOOLEAN_VALUEOF) || Helper.isMethodCallChain(methodNode, ID_VALUEOF) || Helper.isMethodCallChain(methodNode, STRING_ISEMPTY) || Helper.isMethodCallChain(methodNode, STRING_ISBLANK) || Helper.isMethodCallChain(methodNode, STRING_ISNOTBLANK);
    }

    private void processInlineMethodCalls(ASTMethodCallExpression methodNode, Object data, boolean isNested) {
        ASTMethodCallExpression nestedCall = (ASTMethodCallExpression)methodNode.getFirstChildOfType(ASTMethodCallExpression.class);
        if (nestedCall != null && !this.isEscapingMethod(methodNode)) {
            this.processInlineMethodCalls(nestedCall, data, true);
        }
        if (Helper.isMethodCallChain(methodNode, URL_PARAMETER_METHOD) && isNested) {
            this.addViolation(data, methodNode);
        }
    }

    private void findTaintedVariables(AbstractApexNode<?> node, Object data) {
        ASTMethodCallExpression right = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class);
        if (right != null) {
            ASTVariableExpression left;
            if (Helper.isMethodCallChain(right, URL_PARAMETER_METHOD) && (left = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class)) != null) {
                this.urlParameterStrings.add(Helper.getFQVariableName(left));
            }
            this.processEscapingMethodCalls(right, data);
        }
    }

    private void processEscapingMethodCalls(ASTMethodCallExpression methodNode, Object data) {
        ASTVariableExpression variable;
        ASTMethodCallExpression nestedCall = (ASTMethodCallExpression)methodNode.getFirstChildOfType(ASTMethodCallExpression.class);
        if (nestedCall != null) {
            this.processEscapingMethodCalls(nestedCall, data);
        }
        if ((variable = (ASTVariableExpression)methodNode.getFirstChildOfType(ASTVariableExpression.class)) != null && this.urlParameterStrings.contains(Helper.getFQVariableName(variable)) && !this.isEscapingMethod(methodNode)) {
            this.addViolation(data, variable);
        }
    }

    private void processVariableAssignments(AbstractApexNode<?> node, Object data, boolean reverseOrder) {
        ASTMethodCallExpression methodCallAssignment = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class);
        if (methodCallAssignment != null) {
            this.processInlineMethodCalls(methodCallAssignment, data, false);
        }
        List nodes = node.findChildrenOfType(ASTVariableExpression.class);
        switch (nodes.size()) {
            case 1: {
                List ops = node.findChildrenOfType(ASTBinaryExpression.class);
                if (ops.isEmpty()) break;
                for (ASTBinaryExpression o : ops) {
                    this.processBinaryExpression(o, data);
                }
                break;
            }
            case 2: {
                ASTVariableExpression right;
                ASTVariableExpression aSTVariableExpression = right = reverseOrder ? (ASTVariableExpression)nodes.get(0) : (ASTVariableExpression)nodes.get(1);
                if (!this.urlParameterStrings.contains(Helper.getFQVariableName(right))) break;
                this.addViolation(data, right);
                break;
            }
        }
    }

    private void processBinaryExpression(AbstractApexNode<?> node, Object data) {
        ASTMethodCallExpression methodCallAssignment;
        ASTBinaryExpression nestedBinaryExpression = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (nestedBinaryExpression != null) {
            this.processBinaryExpression(nestedBinaryExpression, data);
        }
        if ((methodCallAssignment = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class)) != null) {
            this.processInlineMethodCalls(methodCallAssignment, data, true);
        }
        List nodes = node.findChildrenOfType(ASTVariableExpression.class);
        for (ASTVariableExpression n : nodes) {
            if (!this.urlParameterStrings.contains(Helper.getFQVariableName(n))) continue;
            this.addViolation(data, n);
        }
    }
}

