/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.member.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;

public class ApexSuggestUsingNamedCredRule
extends AbstractApexRule {
    private static final String SET_HEADER = "setHeader";
    private static final String AUTHORIZATION = "Authorization";
    private final Set<String> listOfAuthorizationVariables = new HashSet<String>();

    public ApexSuggestUsingNamedCredRule() {
        super.addRuleChainVisit(ASTUserClass.class);
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        List variableDecls = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (Object varDecl : variableDecls) {
            this.findAuthLiterals((AbstractApexNode<?>)varDecl);
        }
        List fieldDecl = node.findDescendantsOfType(ASTField.class);
        for (ASTField fDecl : fieldDecl) {
            this.findFieldLiterals(fDecl);
        }
        List methodCalls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression method : methodCalls) {
            this.flagAuthorizationHeaders(method, data);
        }
        this.listOfAuthorizationVariables.clear();
        return data;
    }

    private void findFieldLiterals(ASTField fDecl) {
        String fieldValue;
        Object f = ((Field)fDecl.getNode()).getFieldInfo().getValue();
        if (f != null && f instanceof String && AUTHORIZATION.equalsIgnoreCase(fieldValue = (String)f)) {
            this.listOfAuthorizationVariables.add(Helper.getFQVariableName(fDecl));
        }
    }

    private void flagAuthorizationHeaders(ASTMethodCallExpression node, Object data) {
        if (!Helper.isMethodName(node, SET_HEADER)) {
            return;
        }
        ASTBinaryExpression binaryNode = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (binaryNode != null) {
            this.runChecks(binaryNode, data);
        }
        this.runChecks(node, data);
    }

    private void findAuthLiterals(AbstractApexNode<?> node) {
        ASTVariableExpression variable;
        ASTLiteralExpression literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class);
        if (literal != null && (variable = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class)) != null && this.isAuthorizationLiteral(literal)) {
            this.listOfAuthorizationVariables.add(Helper.getFQVariableName(variable));
        }
    }

    private void runChecks(AbstractApexNode<?> node, Object data) {
        ASTVariableExpression varNode;
        ASTLiteralExpression literalNode = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class);
        if (literalNode != null && this.isAuthorizationLiteral(literalNode)) {
            this.addViolation(data, literalNode);
        }
        if ((varNode = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class)) != null && this.listOfAuthorizationVariables.contains(Helper.getFQVariableName(varNode))) {
            this.addViolation(data, varNode);
        }
    }

    private boolean isAuthorizationLiteral(ASTLiteralExpression literal) {
        String lit;
        Object o = ((LiteralExpression)literal.getNode()).getLiteral();
        return o instanceof String && (lit = (String)o).equalsIgnoreCase(AUTHORIZATION);
    }
}

