/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.semantic.ast.expression.LiteralExpression;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;

public class ApexSOQLInjectionRule
extends AbstractApexRule {
    private static final String JOIN = "join";
    private static final String ESCAPE_SINGLE_QUOTES = "escapeSingleQuotes";
    private static final String STRING = "String";
    private static final String DATABASE = "Database";
    private static final String QUERY = "query";
    private static final Pattern SELECT_PATTERN = Pattern.compile("^select[\\s]+?.*?$", 2);
    private final HashSet<String> safeVariables = new HashSet();
    private final HashMap<String, Boolean> selectContainingVariables = new HashMap();

    public ApexSOQLInjectionRule() {
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        List fieldExpr = node.findDescendantsOfType(ASTFieldDeclaration.class);
        for (Object a : fieldExpr) {
            this.findSanitizedVariables((AbstractApexNode<?>)a);
            this.findSelectContainingVariables((AbstractApexNode<?>)a);
        }
        List variableDecl = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (Object a : variableDecl) {
            this.findSanitizedVariables((AbstractApexNode<?>)a);
            this.findSelectContainingVariables((AbstractApexNode<?>)a);
        }
        List assignmentCalls = node.findDescendantsOfType(ASTAssignmentExpression.class);
        for (ASTAssignmentExpression a : assignmentCalls) {
            this.findSanitizedVariables(a);
            this.findSelectContainingVariables(a);
        }
        List potentialDbQueryCalls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression m : potentialDbQueryCalls) {
            if (Helper.isTestMethodOrClass(m) || !Helper.isMethodName(m, DATABASE, QUERY)) continue;
            this.reportStrings(m, data);
            this.reportVariables(m, data);
        }
        this.safeVariables.clear();
        this.selectContainingVariables.clear();
        return data;
    }

    private void findSanitizedVariables(AbstractApexNode<?> node) {
        ASTVariableExpression left = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        ASTLiteralExpression literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class);
        ASTMethodCallExpression right = (ASTMethodCallExpression)node.getFirstChildOfType(ASTMethodCallExpression.class);
        if (literal != null && left != null) {
            Object o = ((LiteralExpression)literal.getNode()).getLiteral();
            if (o instanceof Integer || o instanceof Boolean || o instanceof Double) {
                this.safeVariables.add(Helper.getFQVariableName(left));
            }
            if (o instanceof String) {
                if (SELECT_PATTERN.matcher((String)o).matches()) {
                    this.selectContainingVariables.put(Helper.getFQVariableName(left), Boolean.TRUE);
                } else {
                    this.safeVariables.add(Helper.getFQVariableName(left));
                }
            }
        }
        if (right != null && Helper.isMethodName(right, STRING, ESCAPE_SINGLE_QUOTES) && left != null) {
            this.safeVariables.add(Helper.getFQVariableName(left));
        }
    }

    private void findSelectContainingVariables(AbstractApexNode<?> node) {
        ASTVariableExpression left = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        ASTBinaryExpression right = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (left != null && right != null) {
            this.recursivelyCheckForSelect(left, right);
        }
    }

    private void recursivelyCheckForSelect(ASTVariableExpression var, ASTBinaryExpression node) {
        ASTLiteralExpression literal;
        ASTBinaryExpression right = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (right != null) {
            this.recursivelyCheckForSelect(var, right);
        }
        ASTVariableExpression concatenatedVar = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        boolean isSafeVariable = false;
        if (concatenatedVar != null && this.safeVariables.contains(Helper.getFQVariableName(concatenatedVar))) {
            isSafeVariable = true;
        }
        if ((literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class)) != null) {
            Object o = ((LiteralExpression)literal.getNode()).getLiteral();
            if (o instanceof String && SELECT_PATTERN.matcher((String)o).matches() && !isSafeVariable) {
                this.selectContainingVariables.put(Helper.getFQVariableName(var), Boolean.FALSE);
            }
        } else if (!isSafeVariable) {
            this.selectContainingVariables.put(Helper.getFQVariableName(var), Boolean.FALSE);
        }
    }

    private void reportStrings(ASTMethodCallExpression m, Object data) {
        List binaryExpr = m.findChildrenOfType(ASTBinaryExpression.class);
        for (ASTBinaryExpression b : binaryExpr) {
            List vars = b.findDescendantsOfType(ASTVariableExpression.class);
            for (ASTVariableExpression v : vars) {
                ASTMethodCallExpression parentCall;
                boolean isSafeMethod;
                boolean isLiteral;
                String fqName = Helper.getFQVariableName(v);
                if (this.selectContainingVariables.containsKey(fqName) && (isLiteral = this.selectContainingVariables.get(fqName).booleanValue()) || this.safeVariables.contains(fqName) || (isSafeMethod = Helper.isMethodName(parentCall = (ASTMethodCallExpression)v.getFirstParentOfType(ASTMethodCallExpression.class), STRING, ESCAPE_SINGLE_QUOTES) || Helper.isMethodName(parentCall, STRING, JOIN))) continue;
                this.addViolation(data, v);
            }
        }
    }

    private void reportVariables(ASTMethodCallExpression m, Object data) {
        boolean isLiteral;
        String nameFQ;
        ASTVariableExpression var = (ASTVariableExpression)m.getFirstChildOfType(ASTVariableExpression.class);
        if (var != null && this.selectContainingVariables.containsKey(nameFQ = Helper.getFQVariableName(var)) && !(isLiteral = this.selectContainingVariables.get(nameFQ).booleanValue())) {
            this.addViolation(data, var);
        }
    }
}

