/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTBinaryExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTLiteralExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTNewObjectExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.AbstractApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;

public class ApexOpenRedirectRule
extends AbstractApexRule {
    private static final String PAGEREFERENCE = "PageReference";
    private final Set<String> listOfStringLiteralVariables = new HashSet<String>();

    public ApexOpenRedirectRule() {
        super.addRuleChainVisit(ASTUserClass.class);
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        List assignmentExprs = node.findDescendantsOfType(ASTAssignmentExpression.class);
        for (Object assignment : assignmentExprs) {
            this.findSafeLiterals((AbstractApexNode<?>)assignment);
        }
        List variableDecls = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (Object varDecl : variableDecls) {
            this.findSafeLiterals((AbstractApexNode<?>)varDecl);
        }
        List fieldDecl = node.findDescendantsOfType(ASTField.class);
        for (ASTField fDecl : fieldDecl) {
            this.findSafeLiterals(fDecl);
        }
        List newObjects = node.findDescendantsOfType(ASTNewObjectExpression.class);
        for (ASTNewObjectExpression newObj : newObjects) {
            this.checkNewObjects(newObj, data);
        }
        this.listOfStringLiteralVariables.clear();
        return data;
    }

    private void findSafeLiterals(AbstractApexNode<?> node) {
        ASTLiteralExpression literal;
        ASTBinaryExpression binaryExp = (ASTBinaryExpression)node.getFirstChildOfType(ASTBinaryExpression.class);
        if (binaryExp != null) {
            this.findSafeLiterals(binaryExp);
        }
        if ((literal = (ASTLiteralExpression)node.getFirstChildOfType(ASTLiteralExpression.class)) != null) {
            int index = literal.jjtGetChildIndex();
            if (index == 0) {
                if (node instanceof ASTVariableDeclaration) {
                    this.addVariable((ASTVariableDeclaration)node);
                } else if (node instanceof ASTBinaryExpression) {
                    ASTVariableExpression var;
                    ASTAssignmentExpression assignment;
                    ASTVariableDeclaration parent = (ASTVariableDeclaration)node.getFirstParentOfType(ASTVariableDeclaration.class);
                    if (parent != null) {
                        this.addVariable(parent);
                    }
                    if ((assignment = (ASTAssignmentExpression)node.getFirstParentOfType(ASTAssignmentExpression.class)) != null && (var = (ASTVariableExpression)assignment.getFirstChildOfType(ASTVariableExpression.class)) != null) {
                        this.addVariable(var);
                    }
                }
            }
        } else if (node instanceof ASTField) {
            try {
                Field f = node.getNode().getClass().getDeclaredField("fieldInfo");
                f.setAccessible(true);
                StandardFieldInfo fieldInfo = (StandardFieldInfo)f.get(node.getNode());
                if (fieldInfo.getType().getApexName().equalsIgnoreCase("String") && fieldInfo.getValue() != null) {
                    this.addVariable(fieldInfo);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    private void addVariable(StandardFieldInfo fieldInfo) {
        StringBuilder sb = new StringBuilder().append(fieldInfo.getDefiningType().getApexName()).append(":").append(fieldInfo.getName());
        this.listOfStringLiteralVariables.add(sb.toString());
    }

    private void addVariable(ASTVariableDeclaration node) {
        ASTVariableExpression variable = (ASTVariableExpression)node.getFirstChildOfType(ASTVariableExpression.class);
        this.addVariable(variable);
    }

    private void addVariable(ASTVariableExpression node) {
        if (node != null) {
            this.listOfStringLiteralVariables.add(Helper.getFQVariableName(node));
        }
    }

    private void checkNewObjects(ASTNewObjectExpression node, Object data) {
        ASTMethod method = (ASTMethod)node.getFirstParentOfType(ASTMethod.class);
        if (method != null && Helper.isTestMethodOrClass(method)) {
            return;
        }
        TypeRef.ClassTypeRef classRef = (TypeRef.ClassTypeRef)((NewObjectExpression)node.getNode()).getTypeRef();
        Identifier identifier = (Identifier)classRef.className.get(0);
        if (identifier.value.equalsIgnoreCase(PAGEREFERENCE)) {
            this.getObjectValue(node, data);
        }
    }

    private void getObjectValue(ApexNode<?> node, Object data) {
        List variableExpressions = node.findChildrenOfType(ASTVariableExpression.class);
        for (ASTVariableExpression variable : variableExpressions) {
            if (variable.jjtGetChildIndex() != 0 || this.listOfStringLiteralVariables.contains(Helper.getFQVariableName(variable))) continue;
            this.addViolation(data, variable);
        }
        List binaryExpressions = node.findChildrenOfType(ASTBinaryExpression.class);
        for (ASTBinaryExpression z : binaryExpressions) {
            this.getObjectValue(z, data);
        }
    }
}

