/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.statement.VariableDeclaration;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTField;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;

public class ApexDangerousMethodsRule
extends AbstractApexRule {
    private static final String BOOLEAN = "boolean";
    private static final Pattern regexp = Pattern.compile("^.*?(pass|pwd|crypt|auth|session|token|saml)(?!id|user).*?$", 2);
    private static final String DISABLE_CRUD = "disableTriggerCRUDSecurity";
    private static final String CONFIGURATION = "Configuration";
    private static final String SYSTEM = "System";
    private static final String DEBUG = "debug";
    private final HashSet<String> whiteListedVariables = new HashSet();

    public ApexDangerousMethodsRule() {
        super.addRuleChainVisit(ASTUserClass.class);
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node)) {
            return data;
        }
        this.collectBenignVariables(node);
        List methodCalls = node.findDescendantsOfType(ASTMethodCallExpression.class);
        for (ASTMethodCallExpression methodCall : methodCalls) {
            if (Helper.isMethodName(methodCall, CONFIGURATION, DISABLE_CRUD)) {
                this.addViolation(data, methodCall);
            }
            if (!Helper.isMethodName(methodCall, SYSTEM, DEBUG)) continue;
            this.validateParameters(methodCall, data);
        }
        this.whiteListedVariables.clear();
        return data;
    }

    private void collectBenignVariables(ASTUserClass node) {
        List fields = node.findDescendantsOfType(ASTField.class);
        for (ASTField field : fields) {
            if (!BOOLEAN.equalsIgnoreCase(((Field)field.getNode()).getFieldInfo().getType().getApexName())) continue;
            this.whiteListedVariables.add(Helper.getFQVariableName(field));
        }
        List declarations = node.findDescendantsOfType(ASTVariableDeclaration.class);
        for (ASTVariableDeclaration decl : declarations) {
            if (!BOOLEAN.equalsIgnoreCase(((VariableDeclaration)decl.getNode()).getLocalInfo().getType().getApexName())) continue;
            this.whiteListedVariables.add(Helper.getFQVariableName(decl));
        }
    }

    private void validateParameters(ASTMethodCallExpression methodCall, Object data) {
        List variables = methodCall.findDescendantsOfType(ASTVariableExpression.class);
        for (ASTVariableExpression var : variables) {
            if (!regexp.matcher(((VariableExpression)var.getNode()).getIdentifier().value).matches() || this.whiteListedVariables.contains(Helper.getFQVariableName(var))) continue;
            this.addViolation(data, methodCall);
        }
    }
}

