/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.security;

import apex.jorje.semantic.ast.member.Method;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.security.Helper;

public class ApexCSRFRule
extends AbstractApexRule {
    public static final String INIT = "init";

    public ApexCSRFRule() {
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!Helper.isTestMethodOrClass(node)) {
            this.checkForCSRF(node, data);
        }
        return data;
    }

    private void checkForCSRF(ASTMethod node, Object data) {
        String name;
        if (((Method)node.getNode()).getMethodInfo().isConstructor() && Helper.foundAnyDML(node)) {
            this.addViolation(data, node);
        }
        if ((name = ((Method)node.getNode()).getMethodInfo().getName()).equalsIgnoreCase(INIT) && Helper.foundAnyDML(node)) {
            this.addViolation(data, node);
        }
    }
}

