/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.performance;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTDoLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForEachStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTForLoopStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTSoqlExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTWhileLoopStatement;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.ast.Node;

public class AvoidSoqlInLoopsRule
extends AbstractApexRule {
    public AvoidSoqlInLoopsRule() {
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Performance"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 150);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTSoqlExpression node, Object data) {
        if (this.insideLoop(node) && this.parentNotReturn(node) && this.parentNotForEach(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private boolean parentNotReturn(ASTSoqlExpression node) {
        return !(node.jjtGetParent() instanceof ASTReturnStatement);
    }

    private boolean parentNotForEach(ASTSoqlExpression node) {
        return !(node.jjtGetParent() instanceof ASTForEachStatement);
    }

    private boolean insideLoop(ASTSoqlExpression node) {
        for (Node n = node.jjtGetParent(); n != null; n = n.jjtGetParent()) {
            if (!(n instanceof ASTDoLoopStatement) && !(n instanceof ASTWhileLoopStatement) && !(n instanceof ASTForLoopStatement) && !(n instanceof ASTForEachStatement)) continue;
            return true;
        }
        return false;
    }
}

