/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.complexity;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.apex.ast.ASTIfBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractApexRule {
    private int depth;
    private int depthLimit;
    private static final IntegerProperty PROBLEM_DEPTH_DESCRIPTOR = new IntegerProperty("problemDepth", "The if statement depth reporting threshold", Integer.valueOf(1), Integer.valueOf(25), Integer.valueOf(3), 1.0f);

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
        this.setProperty((PropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Complexity"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 200);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        this.depth = 0;
        this.depthLimit = (Integer)this.getProperty((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfBlockStatement node, Object data) {
        ++this.depth;
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, node);
        }
        --this.depth;
        return data;
    }
}

