/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.apexunit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTMethodCallExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTStatement;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.apexunit.AbstractApexUnitTestRule;

public class ApexUnitTestClassShouldHaveAsserts
extends AbstractApexUnitTestRule {
    private static final Set<String> ASSERT_METHODS = new HashSet<String>();

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!this.isTestMethodOrClass(node)) {
            return data;
        }
        return this.checkForAssertStatements(node, data);
    }

    private Object checkForAssertStatements(ApexNode<?> node, Object data) {
        List blockStatements = node.findDescendantsOfType(ASTBlockStatement.class);
        ArrayList statements = new ArrayList();
        ArrayList methodCalls = new ArrayList();
        for (ASTBlockStatement blockStatement : blockStatements) {
            statements.addAll(blockStatement.findDescendantsOfType(ASTStatement.class));
            methodCalls.addAll(blockStatement.findDescendantsOfType(ASTMethodCallExpression.class));
        }
        boolean isAssertFound = false;
        for (ASTMethodCallExpression methodCallExpression : methodCalls) {
            if (!ASSERT_METHODS.contains(methodCallExpression.getFullMethodName().toLowerCase())) continue;
            isAssertFound = true;
            break;
        }
        if (!isAssertFound) {
            this.addViolation(data, node);
        }
        return data;
    }

    static {
        ASSERT_METHODS.add("system.assert");
        ASSERT_METHODS.add("system.assertequals");
        ASSERT_METHODS.add("system.assertnotequals");
    }
}

