/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.ApexCompiler;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.compiler.CompilationInput;
import apex.jorje.semantic.compiler.CompilerContext;
import apex.jorje.semantic.compiler.CompilerOperation;
import apex.jorje.semantic.compiler.CompilerStage;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.QueryValidator;
import apex.jorje.semantic.compiler.sfdc.SymbolProvider;
import apex.jorje.semantic.tester.EmptySymbolProvider;
import apex.jorje.semantic.tester.TestAccessEvaluator;
import apex.jorje.semantic.tester.TestQueryValidators;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;

public class CompilerService {
    public static final CompilerService INSTANCE = new CompilerService();
    private final SymbolProvider symbolProvider;
    private final AccessEvaluator accessEvaluator;
    private QueryValidator queryValidator;

    CompilerService() {
        this((SymbolProvider)EmptySymbolProvider.get(), (AccessEvaluator)new TestAccessEvaluator(), (QueryValidator)new TestQueryValidators.Noop());
    }

    public CompilerService(SymbolProvider symbolProvider, AccessEvaluator accessEvaluator, QueryValidator queryValidator) {
        this.symbolProvider = symbolProvider;
        this.accessEvaluator = accessEvaluator;
        this.queryValidator = queryValidator;
    }

    public ApexCompiler visitAstFromString(String source, AstVisitor<AdditionalPassScope> visitor) {
        return this.visitAstsFromStrings((List<String>)ImmutableList.of((Object)source), visitor, CompilerStage.POST_TYPE_RESOLVE);
    }

    public ApexCompiler visitAstsFromStrings(List<String> sources, AstVisitor<AdditionalPassScope> visitor) {
        return this.visitAstsFromStrings(sources, visitor, CompilerStage.POST_TYPE_RESOLVE);
    }

    public ApexCompiler visitAstsFromStrings(List<String> sources, AstVisitor<AdditionalPassScope> visitor, CompilerStage compilerStage) {
        List<SourceFile> sourceFiles = sources.stream().map(s -> SourceFile.builder().setBody(s).build()).collect(Collectors.toList());
        CompilationInput compilationUnit = this.createCompilationInput(sourceFiles, visitor);
        return this.compile(compilationUnit, visitor, compilerStage);
    }

    private ApexCompiler compile(CompilationInput compilationInput, AstVisitor<AdditionalPassScope> visitor, CompilerStage compilerStage) {
        ApexCompiler compiler = ApexCompiler.builder().setInput(compilationInput).build();
        compiler.compile(compilerStage);
        this.callAdditionalPassVisitor(compiler);
        return compiler;
    }

    private CompilationInput createCompilationInput(List<SourceFile> sourceFiles, AstVisitor<AdditionalPassScope> visitor) {
        return new CompilationInput(sourceFiles, this.symbolProvider, this.accessEvaluator, this.queryValidator, visitor);
    }

    private void callAdditionalPassVisitor(ApexCompiler compiler) {
        try {
            List allUnits = (List)FieldUtils.readDeclaredField((Object)compiler, (String)"allUnits", (boolean)true);
            CompilerContext compilerContext = (CompilerContext)FieldUtils.readDeclaredField((Object)compiler, (String)"compilerContext", (boolean)true);
            for (CodeUnit unit : allUnits) {
                Method getOperation = CompilerStage.ADDITIONAL_VALIDATE.getDeclaringClass().getDeclaredMethod("getOperation", new Class[0]);
                getOperation.setAccessible(true);
                CompilerOperation operation = (CompilerOperation)getOperation.invoke((Object)CompilerStage.ADDITIONAL_VALIDATE, new Object[0]);
                operation.invoke(compilerContext, unit);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

