/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.ast;

import apex.jorje.data.Loc;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.ast.ApexParserVisitor;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.SourceCodePositioner;

public abstract class AbstractApexNode<T extends AstNode>
extends AbstractNode
implements ApexNode<T> {
    protected final T node;

    public AbstractApexNode(T node) {
        super(node.getClass().hashCode());
        this.node = node;
    }

    void calculateLineNumbers(SourceCodePositioner positioner) {
        if (!this.hasRealLoc()) {
            return;
        }
        Loc.RealLoc loc = (Loc.RealLoc)this.node.getLoc();
        int startOffset = loc.startIndex;
        int endOffset = loc.endIndex;
        this.beginLine = positioner.lineNumberFromOffset(startOffset);
        this.beginColumn = positioner.columnFromOffset(this.beginLine, startOffset);
        this.endLine = positioner.lineNumberFromOffset(--endOffset);
        this.endColumn = positioner.columnFromOffset(this.endLine, endOffset);
        if (this.endColumn < 0) {
            this.endColumn = 0;
        }
    }

    public int getBeginLine() {
        if (this.beginLine > 0) {
            return this.beginLine;
        }
        Node parent = this.jjtGetParent();
        if (parent != null) {
            return parent.getBeginLine();
        }
        throw new RuntimeException("Unable to determine beginning line of Node.");
    }

    public int getBeginColumn() {
        if (this.beginColumn > 0) {
            return this.beginColumn;
        }
        Node parent = this.jjtGetParent();
        if (parent != null) {
            return parent.getBeginColumn();
        }
        throw new RuntimeException("Unable to determine beginning column of Node.");
    }

    public int getEndLine() {
        if (this.endLine > 0) {
            return this.endLine;
        }
        Node parent = this.jjtGetParent();
        if (parent != null) {
            return parent.getEndLine();
        }
        throw new RuntimeException("Unable to determine ending line of Node.");
    }

    public int getEndColumn() {
        if (this.endColumn > 0) {
            return this.endColumn;
        }
        Node parent = this.jjtGetParent();
        if (parent != null) {
            return parent.getEndColumn();
        }
        throw new RuntimeException("Unable to determine ending column of Node.");
    }

    @Override
    public Object childrenAccept(ApexParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ApexNode apexNode = (ApexNode)this.children[i];
                apexNode.jjtAccept(visitor, data);
            }
        }
        return data;
    }

    @Override
    public T getNode() {
        return this.node;
    }

    protected boolean hasRealLoc() {
        try {
            Loc loc = this.node.getLoc();
            return loc instanceof Loc.RealLoc;
        }
        catch (UnexpectedCodePathException e) {
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName().replaceFirst("^AST", "");
    }

    public String getLocation() {
        if (this.hasRealLoc()) {
            return String.valueOf(this.node.getLoc());
        }
        return "no location";
    }
}

