CREATE CLASS TypeNameProvider EXTENDS V
ALTER CLASS TypeNameProvider STRICTMODE TRUE
CREATE PROPERTY TypeNameProvider.apexName STRING
CREATE INDEX TypeNameProvider.apexName UNIQUE
CREATE PROPERTY TypeNameProvider.bytecodeName STRING
CREATE INDEX TypeNameProvider.bytecodeName UNIQUE
CREATE PROPERTY TypeNameProvider.typeSignature STRING
CREATE INDEX TypeNameProvider.typeSignature UNIQUE

CREATE CLASS TypeInfo EXTENDS TypeNameProvider
ALTER CLASS TypeInfo STRICTMODE TRUE
CREATE PROPERTY TypeInfo.byteCodeMethodName STRING
CREATE INDEX TypeInfo.byteCodeMethodName UNIQUE
CREATE PROPERTY TypeInfo.isApexSourceBased BOOLEAN
CREATE PROPERTY TypeInfo.name STRING
CREATE PROPERTY TypeInfo.isTrusted BOOLEAN
CREATE PROPERTY TypeInfo.isFileBased BOOLEAN
CREATE PROPERTY TypeInfo.startIndex INTEGER
CREATE PROPERTY TypeInfo.endIndex INTEGER
CREATE PROPERTY TypeInfo.line INTEGER
CREATE PROPERTY TypeInfo.column INTEGER

CREATE CLASS SourceFile EXTENDS V
ALTER CLASS SourceFile STRICTMODE TRUE
CREATE PROPERTY SourceFile.knownName STRING
CREATE INDEX SourceFile.knownName UNIQUE

CREATE CLASS Supertype EXTENDS E
CREATE PROPERTY Supertype.in LINK TypeInfo
CREATE PROPERTY Supertype.out LINK TypeInfo
CREATE PROPERTY TypeInfo.out_Supertype LINKBAG
CREATE PROPERTY TypeInfo.in_Supertype LINKBAG

CREATE CLASS ImmediateInterfaces EXTENDS E
CREATE PROPERTY ImmediateInterfaces.in LINK TypeInfo
CREATE PROPERTY ImmediateInterfaces.out LINK TypeInfo
CREATE PROPERTY TypeInfo.out_ImmediateInterfaces LINKBAG
CREATE PROPERTY TypeInfo.in_ImmediateInterfaces LINKBAG

CREATE CLASS AllInterfaces EXTENDS E
CREATE PROPERTY AllInterfaces.in LINK TypeInfo
CREATE PROPERTY AllInterfaces.out LINK TypeInfo
CREATE PROPERTY TypeInfo.out_AllInterfaces LINKBAG
CREATE PROPERTY TypeInfo.in_AllInterfaces LINKBAG

CREATE CLASS Source EXTENDS E
CREATE PROPERTY Source.in LINK SourceFile
CREATE PROPERTY Source.out LINK TypeInfo
CREATE PROPERTY TypeInfo.out_Source LINKBAG
CREATE PROPERTY SourceFile.in_Source LINKBAG

