/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.util;

import java.io.Serializable;
import shaded.com.fasterxml.jackson.core.io.SerializedString;
import shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import shaded.com.fasterxml.jackson.databind.BeanDescription;
import shaded.com.fasterxml.jackson.databind.JavaType;
import shaded.com.fasterxml.jackson.databind.PropertyName;
import shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import shaded.com.fasterxml.jackson.databind.type.ClassKey;
import shaded.com.fasterxml.jackson.databind.util.LRUMap;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType javaType, MapperConfig<?> mapperConfig) {
        return this.findRootName(javaType.getRawClass(), mapperConfig);
    }

    public synchronized SerializedString findRootName(Class<?> clazz, MapperConfig<?> mapperConfig) {
        Object object;
        ClassKey classKey = new ClassKey(clazz);
        if (this._rootNames == null) {
            this._rootNames = new LRUMap(20, 200);
        } else {
            object = (SerializedString)this._rootNames.get(classKey);
            if (object != null) {
                return object;
            }
        }
        object = mapperConfig.introspectClassAnnotations(clazz);
        AnnotationIntrospector annotationIntrospector = mapperConfig.getAnnotationIntrospector();
        AnnotatedClass annotatedClass = ((BeanDescription)object).getClassInfo();
        PropertyName propertyName = annotationIntrospector.findRootName(annotatedClass);
        String string = propertyName == null || !propertyName.hasSimpleName() ? clazz.getSimpleName() : propertyName.getSimpleName();
        SerializedString serializedString = new SerializedString(string);
        this._rootNames.put(classKey, serializedString);
        return serializedString;
    }
}

