/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import shaded.com.fasterxml.jackson.core.JsonGenerationException;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import shaded.com.fasterxml.jackson.databind.BeanProperty;
import shaded.com.fasterxml.jackson.databind.JavaType;
import shaded.com.fasterxml.jackson.databind.JsonMappingException;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializationFeature;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shaded.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import shaded.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import shaded.com.fasterxml.jackson.databind.util.Converter;

public abstract class StdSerializer<T>
extends JsonSerializer<T>
implements JsonFormatVisitable,
SchemaAware {
    protected final Class<T> _handledType;

    protected StdSerializer(Class<T> clazz) {
        this._handledType = clazz;
    }

    protected StdSerializer(JavaType javaType) {
        this._handledType = javaType.getRawClass();
    }

    protected StdSerializer(Class<?> clazz, boolean bl) {
        this._handledType = clazz;
    }

    @Override
    public Class<T> handledType() {
        return this._handledType;
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonGenerationException;

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type, boolean bl) throws JsonMappingException {
        ObjectNode objectNode = (ObjectNode)this.getSchema(serializerProvider, type);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    protected ObjectNode createObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    protected ObjectNode createSchemaNode(String string) {
        ObjectNode objectNode = this.createObjectNode();
        objectNode.put("type", string);
        return objectNode;
    }

    protected ObjectNode createSchemaNode(String string, boolean bl) {
        ObjectNode objectNode = this.createSchemaNode(string);
        if (!bl) {
            objectNode.put("required", !bl);
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        jsonFormatVisitorWrapper.expectAnyFormat(javaType);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, String string) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, string);
    }

    public void wrapAndThrow(SerializerProvider serializerProvider, Throwable throwable, Object object, int n) throws IOException {
        boolean bl;
        while (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        boolean bl2 = bl = serializerProvider == null || serializerProvider.isEnabled(SerializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl || !(throwable instanceof JsonMappingException)) {
                throw (IOException)throwable;
            }
        } else if (!bl && throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw JsonMappingException.wrapWithPath(throwable, object, n);
    }

    protected boolean isDefaultSerializer(JsonSerializer<?> jsonSerializer) {
        return jsonSerializer != null && jsonSerializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    protected JsonSerializer<?> findConvertingContentSerializer(SerializerProvider serializerProvider, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer) throws JsonMappingException {
        Object object;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (object = annotationIntrospector.findSerializationContentConverter(beanProperty.getMember())) != null) {
            Converter<Object, Object> converter = serializerProvider.converterInstance(beanProperty.getMember(), object);
            JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
            if (jsonSerializer == null) {
                jsonSerializer = serializerProvider.findValueSerializer(javaType, beanProperty);
            }
            return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
        }
        return jsonSerializer;
    }
}

