/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.net.InetAddress;
import shaded.com.fasterxml.jackson.core.JsonGenerationException;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import shaded.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;

public class InetAddressSerializer
extends StdScalarSerializer<InetAddress> {
    public static final InetAddressSerializer instance = new InetAddressSerializer();

    public InetAddressSerializer() {
        super(InetAddress.class);
    }

    @Override
    public void serialize(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        String string = inetAddress.toString().trim();
        int n = string.indexOf(47);
        if (n >= 0) {
            string = n == 0 ? string.substring(1) : string.substring(0, n);
        }
        jsonGenerator.writeString(string);
    }

    @Override
    public void serializeWithType(InetAddress inetAddress, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForScalar(inetAddress, jsonGenerator, InetAddress.class);
        this.serialize(inetAddress, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForScalar(inetAddress, jsonGenerator);
    }
}

