/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.ser.impl;

import java.io.IOException;
import shaded.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import shaded.com.fasterxml.jackson.core.JsonGenerationException;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.io.SerializedString;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> objectIdGenerator) {
        this.generator = objectIdGenerator;
    }

    public boolean writeAsId(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectIdWriter objectIdWriter) throws IOException, JsonGenerationException {
        if (this.id != null && (this.idWritten || objectIdWriter.alwaysAsId)) {
            objectIdWriter.serializer.serialize(this.id, jsonGenerator, serializerProvider);
            return true;
        }
        return false;
    }

    public Object generateId(Object object) {
        this.id = this.generator.generateId(object);
        return this.id;
    }

    public void writeAsField(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectIdWriter objectIdWriter) throws IOException, JsonGenerationException {
        SerializedString serializedString = objectIdWriter.propertyName;
        this.idWritten = true;
        if (serializedString != null) {
            jsonGenerator.writeFieldName(serializedString);
            objectIdWriter.serializer.serialize(this.id, jsonGenerator, serializerProvider);
        }
    }
}

