/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.ser.impl;

import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.databind.JsonSerializer;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import shaded.com.fasterxml.jackson.databind.util.NameTransformer;

public abstract class FilteredBeanPropertyWriter {
    public static BeanPropertyWriter constructViewBased(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
        if (classArray.length == 1) {
            return new SingleView(beanPropertyWriter, classArray[0]);
        }
        return new MultiView(beanPropertyWriter, classArray);
    }

    private static final class MultiView
    extends BeanPropertyWriter {
        protected final BeanPropertyWriter _delegate;
        protected final Class<?>[] _views;

        protected MultiView(BeanPropertyWriter beanPropertyWriter, Class<?>[] classArray) {
            super(beanPropertyWriter);
            this._delegate = beanPropertyWriter;
            this._views = classArray;
        }

        @Override
        public MultiView rename(NameTransformer nameTransformer) {
            return new MultiView(this._delegate.rename(nameTransformer), this._views);
        }

        @Override
        public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignSerializer(jsonSerializer);
        }

        @Override
        public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignNullSerializer(jsonSerializer);
        }

        @Override
        public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz != null) {
                int n;
                int n2 = this._views.length;
                for (n = 0; n < n2 && !this._views[n].isAssignableFrom(clazz); ++n) {
                }
                if (n == n2) {
                    return;
                }
            }
            this._delegate.serializeAsField(object, jsonGenerator, serializerProvider);
        }

        @Override
        public void serializeAsColumn(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz != null) {
                int n;
                int n2 = this._views.length;
                for (n = 0; n < n2 && !this._views[n].isAssignableFrom(clazz); ++n) {
                }
                if (n == n2) {
                    this._delegate.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                    return;
                }
            }
            this._delegate.serializeAsColumn(object, jsonGenerator, serializerProvider);
        }
    }

    private static final class SingleView
    extends BeanPropertyWriter {
        protected final BeanPropertyWriter _delegate;
        protected final Class<?> _view;

        protected SingleView(BeanPropertyWriter beanPropertyWriter, Class<?> clazz) {
            super(beanPropertyWriter);
            this._delegate = beanPropertyWriter;
            this._view = clazz;
        }

        @Override
        public SingleView rename(NameTransformer nameTransformer) {
            return new SingleView(this._delegate.rename(nameTransformer), this._view);
        }

        @Override
        public void assignSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignSerializer(jsonSerializer);
        }

        @Override
        public void assignNullSerializer(JsonSerializer<Object> jsonSerializer) {
            this._delegate.assignNullSerializer(jsonSerializer);
        }

        @Override
        public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz == null || this._view.isAssignableFrom(clazz)) {
                this._delegate.serializeAsField(object, jsonGenerator, serializerProvider);
            }
        }

        @Override
        public void serializeAsColumn(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
            Class<?> clazz = serializerProvider.getActiveView();
            if (clazz == null || this._view.isAssignableFrom(clazz)) {
                this._delegate.serializeAsColumn(object, jsonGenerator, serializerProvider);
            } else {
                this._delegate.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
            }
        }
    }
}

