/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import shaded.com.fasterxml.jackson.databind.node.BigIntegerNode;
import shaded.com.fasterxml.jackson.databind.node.BinaryNode;
import shaded.com.fasterxml.jackson.databind.node.BooleanNode;
import shaded.com.fasterxml.jackson.databind.node.DecimalNode;
import shaded.com.fasterxml.jackson.databind.node.DoubleNode;
import shaded.com.fasterxml.jackson.databind.node.FloatNode;
import shaded.com.fasterxml.jackson.databind.node.IntNode;
import shaded.com.fasterxml.jackson.databind.node.JsonNodeCreator;
import shaded.com.fasterxml.jackson.databind.node.LongNode;
import shaded.com.fasterxml.jackson.databind.node.NullNode;
import shaded.com.fasterxml.jackson.databind.node.NumericNode;
import shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import shaded.com.fasterxml.jackson.databind.node.POJONode;
import shaded.com.fasterxml.jackson.databind.node.ShortNode;
import shaded.com.fasterxml.jackson.databind.node.TextNode;
import shaded.com.fasterxml.jackson.databind.node.ValueNode;

public class JsonNodeFactory
implements Serializable,
JsonNodeCreator {
    private static final long serialVersionUID = -3271940633258788634L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bl) {
        this._cfgBigDecimalExact = bl;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bl) {
        return bl ? decimalsAsIs : decimalsNormalized;
    }

    @Override
    public BooleanNode booleanNode(boolean bl) {
        return bl ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte by) {
        return IntNode.valueOf(by);
    }

    @Override
    public ValueNode numberNode(Byte by) {
        return by == null ? this.nullNode() : IntNode.valueOf(by.intValue());
    }

    @Override
    public NumericNode numberNode(short s) {
        return ShortNode.valueOf(s);
    }

    @Override
    public ValueNode numberNode(Short s) {
        return s == null ? this.nullNode() : ShortNode.valueOf(s);
    }

    @Override
    public NumericNode numberNode(int n) {
        return IntNode.valueOf(n);
    }

    @Override
    public ValueNode numberNode(Integer n) {
        return n == null ? this.nullNode() : IntNode.valueOf(n);
    }

    @Override
    public NumericNode numberNode(long l) {
        return LongNode.valueOf(l);
    }

    @Override
    public ValueNode numberNode(Long l) {
        return l == null ? this.nullNode() : LongNode.valueOf(l);
    }

    @Override
    public NumericNode numberNode(BigInteger bigInteger) {
        return BigIntegerNode.valueOf(bigInteger);
    }

    @Override
    public NumericNode numberNode(float f) {
        return FloatNode.valueOf(f);
    }

    @Override
    public ValueNode numberNode(Float f) {
        return f == null ? this.nullNode() : FloatNode.valueOf(f.floatValue());
    }

    @Override
    public NumericNode numberNode(double d) {
        return DoubleNode.valueOf(d);
    }

    @Override
    public ValueNode numberNode(Double d) {
        return d == null ? this.nullNode() : DoubleNode.valueOf(d);
    }

    @Override
    public NumericNode numberNode(BigDecimal bigDecimal) {
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(bigDecimal);
        }
        return bigDecimal.compareTo(BigDecimal.ZERO) == 0 ? DecimalNode.ZERO : DecimalNode.valueOf(bigDecimal.stripTrailingZeros());
    }

    @Override
    public TextNode textNode(String string) {
        return TextNode.valueOf(string);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray) {
        return BinaryNode.valueOf(byArray);
    }

    @Override
    public BinaryNode binaryNode(byte[] byArray, int n, int n2) {
        return BinaryNode.valueOf(byArray, n, n2);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object object) {
        return new POJONode(object);
    }

    @Deprecated
    public POJONode POJONode(Object object) {
        return new POJONode(object);
    }
}

