/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import shaded.com.fasterxml.jackson.core.JsonGenerator;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.core.JsonToken;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.fasterxml.jackson.databind.SerializerProvider;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import shaded.com.fasterxml.jackson.databind.node.BaseJsonNode;
import shaded.com.fasterxml.jackson.databind.node.ContainerNode;
import shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import shaded.com.fasterxml.jackson.databind.node.JsonNodeType;
import shaded.com.fasterxml.jackson.databind.node.MissingNode;
import shaded.com.fasterxml.jackson.databind.node.ObjectNode;

public final class ArrayNode
extends ContainerNode<ArrayNode> {
    private final List<JsonNode> _children = new ArrayList<JsonNode>();

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
    }

    public ArrayNode deepCopy() {
        ArrayNode arrayNode = new ArrayNode(this._nodeFactory);
        for (JsonNode jsonNode : this._children) {
            arrayNode._children.add((JsonNode)jsonNode.deepCopy());
        }
        return arrayNode;
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.get(n);
        }
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public JsonNode path(String string) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.get(n);
        }
        return MissingNode.getInstance();
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartArray();
        for (JsonNode jsonNode : this._children) {
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonProcessingException {
        typeSerializer.writeTypePrefixForArray(this, jsonGenerator);
        for (JsonNode jsonNode : this._children) {
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffixForArray(this, jsonGenerator);
    }

    @Override
    public JsonNode findValue(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findValue(string);
            if (jsonNode2 == null) continue;
            return jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findParent(string);
            if (jsonNode2 == null) continue;
            return (ObjectNode)jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findParents(string, list);
        }
        return list;
    }

    public JsonNode set(int n, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        if (n < 0 || n >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n + ", array size " + this.size());
        }
        return this._children.set(n, jsonNode);
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._add(jsonNode);
        return this;
    }

    public ArrayNode addAll(ArrayNode arrayNode) {
        this._children.addAll(arrayNode._children);
        return this;
    }

    public ArrayNode addAll(Collection<JsonNode> collection) {
        this._children.addAll(collection);
        return this;
    }

    public ArrayNode insert(int n, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._insert(n, jsonNode);
        return this;
    }

    public JsonNode remove(int n) {
        if (n >= 0 && n < this._children.size()) {
            return this._children.remove(n);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode arrayNode = this.arrayNode();
        this._add(arrayNode);
        return arrayNode;
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = this.objectNode();
        this._add(objectNode);
        return objectNode;
    }

    public ArrayNode addPOJO(Object object) {
        if (object == null) {
            this.addNull();
        } else {
            this._add(this.pojoNode(object));
        }
        return this;
    }

    public ArrayNode addNull() {
        this._add(this.nullNode());
        return this;
    }

    public ArrayNode add(int n) {
        this._add(this.numberNode(n));
        return this;
    }

    public ArrayNode add(Integer n) {
        if (n == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((int)n));
    }

    public ArrayNode add(long l) {
        return this._add(this.numberNode(l));
    }

    public ArrayNode add(Long l) {
        if (l == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((long)l));
    }

    public ArrayNode add(float f) {
        return this._add(this.numberNode(f));
    }

    public ArrayNode add(Float f) {
        if (f == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(f.floatValue()));
    }

    public ArrayNode add(double d) {
        return this._add(this.numberNode(d));
    }

    public ArrayNode add(Double d) {
        if (d == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((double)d));
    }

    public ArrayNode add(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(bigDecimal));
    }

    public ArrayNode add(String string) {
        if (string == null) {
            return this.addNull();
        }
        return this._add(this.textNode(string));
    }

    public ArrayNode add(boolean bl) {
        return this._add(this.booleanNode(bl));
    }

    public ArrayNode add(Boolean bl) {
        if (bl == null) {
            return this.addNull();
        }
        return this._add(this.booleanNode(bl));
    }

    public ArrayNode add(byte[] byArray) {
        if (byArray == null) {
            return this.addNull();
        }
        return this._add(this.binaryNode(byArray));
    }

    public ArrayNode insertArray(int n) {
        ArrayNode arrayNode = this.arrayNode();
        this._insert(n, arrayNode);
        return arrayNode;
    }

    public ObjectNode insertObject(int n) {
        ObjectNode objectNode = this.objectNode();
        this._insert(n, objectNode);
        return objectNode;
    }

    public ArrayNode insertPOJO(int n, Object object) {
        if (object == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.pojoNode(object));
    }

    public ArrayNode insertNull(int n) {
        this._insert(n, this.nullNode());
        return this;
    }

    public ArrayNode insert(int n, int n2) {
        this._insert(n, this.numberNode(n2));
        return this;
    }

    public ArrayNode insert(int n, Integer n2) {
        if (n2 == null) {
            this.insertNull(n);
        } else {
            this._insert(n, this.numberNode((int)n2));
        }
        return this;
    }

    public ArrayNode insert(int n, long l) {
        return this._insert(n, this.numberNode(l));
    }

    public ArrayNode insert(int n, Long l) {
        if (l == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.numberNode((long)l));
    }

    public ArrayNode insert(int n, float f) {
        return this._insert(n, this.numberNode(f));
    }

    public ArrayNode insert(int n, Float f) {
        if (f == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.numberNode(f.floatValue()));
    }

    public ArrayNode insert(int n, double d) {
        return this._insert(n, this.numberNode(d));
    }

    public ArrayNode insert(int n, Double d) {
        if (d == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.numberNode((double)d));
    }

    public ArrayNode insert(int n, BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.numberNode(bigDecimal));
    }

    public ArrayNode insert(int n, String string) {
        if (string == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.textNode(string));
    }

    public ArrayNode insert(int n, boolean bl) {
        return this._insert(n, this.booleanNode(bl));
    }

    public ArrayNode insert(int n, Boolean bl) {
        if (bl == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.booleanNode(bl));
    }

    public ArrayNode insert(int n, byte[] byArray) {
        if (byArray == null) {
            return this.insertNull(n);
        }
        return this._insert(n, this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this._children.equals(((ArrayNode)object)._children);
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(16 + (this.size() << 4));
        stringBuilder.append('[');
        int n = this._children.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this._children.get(i).toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private ArrayNode _add(JsonNode jsonNode) {
        this._children.add(jsonNode);
        return this;
    }

    private ArrayNode _insert(int n, JsonNode jsonNode) {
        if (n < 0) {
            this._children.add(0, jsonNode);
        } else if (n >= this._children.size()) {
            this._children.add(jsonNode);
        } else {
            this._children.add(n, jsonNode);
        }
        return this;
    }
}

