/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.module;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import shaded.com.fasterxml.jackson.databind.BeanDescription;
import shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import shaded.com.fasterxml.jackson.databind.JavaType;
import shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import shaded.com.fasterxml.jackson.databind.JsonMappingException;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.fasterxml.jackson.databind.KeyDeserializer;
import shaded.com.fasterxml.jackson.databind.deser.Deserializers;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import shaded.com.fasterxml.jackson.databind.type.ArrayType;
import shaded.com.fasterxml.jackson.databind.type.ClassKey;
import shaded.com.fasterxml.jackson.databind.type.CollectionLikeType;
import shaded.com.fasterxml.jackson.databind.type.CollectionType;
import shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import shaded.com.fasterxml.jackson.databind.type.MapType;

public class SimpleDeserializers
implements Deserializers,
Serializable {
    private static final long serialVersionUID = -3006673354353448880L;
    protected HashMap<ClassKey, JsonDeserializer<?>> _classMappings = null;

    public SimpleDeserializers() {
    }

    public SimpleDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        this.addDeserializers(map);
    }

    public <T> void addDeserializer(Class<T> clazz, JsonDeserializer<? extends T> jsonDeserializer) {
        ClassKey classKey = new ClassKey(clazz);
        if (this._classMappings == null) {
            this._classMappings = new HashMap();
        }
        this._classMappings.put(classKey, jsonDeserializer);
    }

    public void addDeserializers(Map<Class<?>, JsonDeserializer<?>> map) {
        for (Map.Entry<Class<?>, JsonDeserializer<?>> entry : map.entrySet()) {
            Class<?> clazz = entry.getKey();
            JsonDeserializer<?> jsonDeserializer = entry.getValue();
            this.addDeserializer(clazz, jsonDeserializer);
        }
    }

    @Override
    public JsonDeserializer<?> findArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(arrayType.getRawClass()));
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(javaType.getRawClass()));
    }

    @Override
    public JsonDeserializer<?> findCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(collectionType.getRawClass()));
    }

    @Override
    public JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(collectionLikeType.getRawClass()));
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(clazz));
    }

    @Override
    public JsonDeserializer<?> findMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(mapType.getRawClass()));
    }

    @Override
    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(mapLikeType.getRawClass()));
    }

    @Override
    public JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return this._classMappings == null ? null : this._classMappings.get(new ClassKey(clazz));
    }
}

