/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.jsontype.impl;

import java.util.Collection;
import shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import shaded.com.fasterxml.jackson.databind.JavaType;
import shaded.com.fasterxml.jackson.databind.SerializationConfig;
import shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import shaded.com.fasterxml.jackson.databind.jsontype.NamedType;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeSerializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeDeserializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeSerializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeSerializer;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import shaded.com.fasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;

public class StdTypeResolverBuilder
implements TypeResolverBuilder<StdTypeResolverBuilder> {
    protected JsonTypeInfo.Id _idType;
    protected JsonTypeInfo.As _includeAs;
    protected String _typeProperty;
    protected boolean _typeIdVisible = false;
    protected Class<?> _defaultImpl;
    protected TypeIdResolver _customIdResolver;

    public static StdTypeResolverBuilder noTypeInfoBuilder() {
        return new StdTypeResolverBuilder().init(JsonTypeInfo.Id.NONE, null);
    }

    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo.Id id, TypeIdResolver typeIdResolver) {
        if (id == null) {
            throw new IllegalArgumentException("idType can not be null");
        }
        this._idType = id;
        this._customIdResolver = typeIdResolver;
        this._typeProperty = id.getDefaultPropertyName();
        return this;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig serializationConfig, JavaType javaType, Collection<NamedType> collection) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        TypeIdResolver typeIdResolver = this.idResolver(serializationConfig, javaType, collection, true, false);
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeSerializer(typeIdResolver, null);
            }
            case PROPERTY: {
                return new AsPropertyTypeSerializer(typeIdResolver, null, this._typeProperty);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeSerializer(typeIdResolver, null);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeSerializer(typeIdResolver, null, this._typeProperty);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)this._includeAs));
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> collection) {
        if (this._idType == JsonTypeInfo.Id.NONE) {
            return null;
        }
        TypeIdResolver typeIdResolver = this.idResolver(deserializationConfig, javaType, collection, false, true);
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeDeserializer(javaType, typeIdResolver, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
            case PROPERTY: {
                return new AsPropertyTypeDeserializer(javaType, typeIdResolver, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeDeserializer(javaType, typeIdResolver, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeDeserializer(javaType, typeIdResolver, this._typeProperty, this._typeIdVisible, this._defaultImpl);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)this._includeAs));
    }

    @Override
    public StdTypeResolverBuilder inclusion(JsonTypeInfo.As as) {
        if (as == null) {
            throw new IllegalArgumentException("includeAs can not be null");
        }
        this._includeAs = as;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String string) {
        if (string == null || string.length() == 0) {
            string = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = string;
        return this;
    }

    @Override
    public StdTypeResolverBuilder defaultImpl(Class<?> clazz) {
        this._defaultImpl = clazz;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeIdVisibility(boolean bl) {
        this._typeIdVisible = bl;
        return this;
    }

    public String getTypeProperty() {
        return this._typeProperty;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl;
    }

    public boolean isTypeIdVisible() {
        return this._typeIdVisible;
    }

    protected TypeIdResolver idResolver(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> collection, boolean bl, boolean bl2) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        if (this._idType == null) {
            throw new IllegalStateException("Can not build, 'init()' not yet called");
        }
        switch (this._idType) {
            case CLASS: {
                return new ClassNameIdResolver(javaType, mapperConfig.getTypeFactory());
            }
            case MINIMAL_CLASS: {
                return new MinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory());
            }
            case NAME: {
                return TypeNameIdResolver.construct(mapperConfig, javaType, collection, bl, bl2);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type id resolver for idType: " + (Object)((Object)this._idType));
    }
}

