/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import shaded.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import shaded.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import shaded.com.fasterxml.jackson.databind.introspect.MemberKey;
import shaded.com.fasterxml.jackson.databind.util.Annotations;
import shaded.com.fasterxml.jackson.databind.util.ClassUtil;

public final class AnnotatedClass
extends Annotated {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final Class<?> _class;
    protected final List<Class<?>> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;
    protected boolean _creatorsResolved = false;
    protected AnnotatedConstructor _defaultConstructor;
    protected List<AnnotatedConstructor> _constructors;
    protected List<AnnotatedMethod> _creatorMethods;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;

    private AnnotatedClass(Class<?> clazz, List<Class<?>> list, AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver, AnnotationMap annotationMap) {
        this._class = clazz;
        this._superTypes = list;
        this._annotationIntrospector = annotationIntrospector;
        this._mixInResolver = mixInResolver;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
        this._classAnnotations = annotationMap;
    }

    @Override
    public AnnotatedClass withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedClass(this._class, this._superTypes, this._annotationIntrospector, this._mixInResolver, annotationMap);
    }

    public static AnnotatedClass construct(Class<?> clazz, AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver) {
        return new AnnotatedClass(clazz, ClassUtil.findSuperTypes(clazz, null), annotationIntrospector, mixInResolver, null);
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> clazz, AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver) {
        return new AnnotatedClass(clazz, Collections.<Class<?>>emptyList(), annotationIntrospector, mixInResolver, null);
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations.get(clazz);
    }

    @Override
    public Type getGenericType() {
        return this._class;
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    protected AnnotationMap getAllAnnotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations;
    }

    public Annotations getAnnotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations;
    }

    public boolean hasAnnotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations.size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._constructors;
    }

    public List<AnnotatedMethod> getStaticMethods() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods;
    }

    public int getMemberMethodCount() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.find(string, classArray);
    }

    public int getFieldCount() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields;
    }

    private void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        if (this._annotationIntrospector != null) {
            if (this._primaryMixIn != null) {
                this._addClassMixIns(this._classAnnotations, this._class, this._primaryMixIn);
            }
            this._addAnnotationsIfNotPresent(this._classAnnotations, this._class.getDeclaredAnnotations());
            for (Class<?> clazz : this._superTypes) {
                this._addClassMixIns(this._classAnnotations, clazz);
                this._addAnnotationsIfNotPresent(this._classAnnotations, clazz.getDeclaredAnnotations());
            }
            this._addClassMixIns(this._classAnnotations, Object.class);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void resolveCreators() {
        void var3_7;
        Constructor<?>[] constructorArray;
        ArrayList<AnnotatedConstructor> arrayList = null;
        for (Constructor<?> constructor : constructorArray = this._class.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length == 0) {
                this._defaultConstructor = this._constructConstructor(constructor, true);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<AnnotatedConstructor>(Math.max(10, constructorArray.length));
            }
            arrayList.add(this._constructConstructor(constructor, false));
        }
        this._constructors = arrayList == null ? Collections.emptyList() : arrayList;
        if (!(this._primaryMixIn == null || this._defaultConstructor == null && this._constructors.isEmpty())) {
            this._addConstructorMixIns(this._primaryMixIn);
        }
        if (this._annotationIntrospector != null) {
            if (this._defaultConstructor != null && this._annotationIntrospector.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            if (this._constructors != null) {
                void var3_5;
                int n = this._constructors.size();
                while (--var3_5 >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._constructors.get((int)var3_5))) continue;
                    this._constructors.remove((int)var3_5);
                }
            }
        }
        Object var3_6 = null;
        for (Method method : this._class.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            if (var3_7 == null) {
                ArrayList arrayList2 = new ArrayList(8);
            }
            var3_7.add(this._constructCreatorMethod(method));
        }
        if (var3_7 == null) {
            this._creatorMethods = Collections.emptyList();
        } else {
            this._creatorMethods = var3_7;
            if (this._primaryMixIn != null) {
                this._addFactoryMixIns(this._primaryMixIn);
            }
            if (this._annotationIntrospector != null) {
                int n = this._creatorMethods.size();
                while (--n >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._creatorMethods.get(n))) continue;
                    this._creatorMethods.remove(n);
                }
            }
        }
        this._creatorsResolved = true;
    }

    private void resolveMemberMethods() {
        GenericDeclaration genericDeclaration;
        this._memberMethods = new AnnotatedMethodMap();
        AnnotatedMethodMap annotatedMethodMap = new AnnotatedMethodMap();
        this._addMemberMethods(this._class, this._memberMethods, this._primaryMixIn, annotatedMethodMap);
        Iterator<AnnotatedMethod> iterator = this._superTypes.iterator();
        while (iterator.hasNext()) {
            Serializable serializable = iterator.next();
            genericDeclaration = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor((Class<?>)serializable);
            this._addMemberMethods((Class<?>)serializable, this._memberMethods, (Class<?>)genericDeclaration, annotatedMethodMap);
        }
        if (this._mixInResolver != null && (iterator = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(this._class, this._memberMethods, (Class<?>)((Object)iterator), annotatedMethodMap);
        }
        if (this._annotationIntrospector != null && !annotatedMethodMap.isEmpty()) {
            for (Serializable serializable : annotatedMethodMap) {
                try {
                    genericDeclaration = Object.class.getDeclaredMethod(((AnnotatedMethod)serializable).getName(), ((AnnotatedMethod)serializable).getRawParameterTypes());
                    if (genericDeclaration == null) continue;
                    AnnotatedMethod annotatedMethod = this._constructMethod((Method)genericDeclaration);
                    this._addMixOvers(((AnnotatedMethod)serializable).getAnnotated(), annotatedMethod, false);
                    this._memberMethods.add(annotatedMethod);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void resolveFields() {
        Map<String, AnnotatedField> map = this._findFields(this._class, null);
        if (map == null || map.size() == 0) {
            this._fields = Collections.emptyList();
        } else {
            this._fields = new ArrayList<AnnotatedField>(map.size());
            this._fields.addAll(map.values());
        }
    }

    protected void _addClassMixIns(AnnotationMap annotationMap, Class<?> clazz) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotationMap, clazz, this._mixInResolver.findMixInClassFor(clazz));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotationMap, Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            return;
        }
        this._addAnnotationsIfNotPresent(annotationMap, clazz2.getDeclaredAnnotations());
        for (Class<?> clazz3 : ClassUtil.findSuperTypes(clazz2, clazz)) {
            this._addAnnotationsIfNotPresent(annotationMap, clazz3.getDeclaredAnnotations());
        }
    }

    protected void _addConstructorMixIns(Class<?> clazz) {
        MemberKey[] memberKeyArray = null;
        int n = this._constructors == null ? 0 : this._constructors.size();
        block0: for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length == 0) {
                if (this._defaultConstructor == null) continue;
                this._addMixOvers(constructor, this._defaultConstructor, false);
                continue;
            }
            if (memberKeyArray == null) {
                memberKeyArray = new MemberKey[n];
                for (int i = 0; i < n; ++i) {
                    memberKeyArray[i] = new MemberKey((Constructor<?>)this._constructors.get(i).getAnnotated());
                }
            }
            MemberKey memberKey = new MemberKey(constructor);
            for (int i = 0; i < n; ++i) {
                if (!memberKey.equals(memberKeyArray[i])) continue;
                this._addMixOvers(constructor, this._constructors.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addFactoryMixIns(Class<?> clazz) {
        MemberKey[] memberKeyArray = null;
        int n = this._creatorMethods.size();
        block0: for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length == 0) continue;
            if (memberKeyArray == null) {
                memberKeyArray = new MemberKey[n];
                for (int i = 0; i < n; ++i) {
                    memberKeyArray[i] = new MemberKey(this._creatorMethods.get(i).getAnnotated());
                }
            }
            MemberKey memberKey = new MemberKey(method);
            for (int i = 0; i < n; ++i) {
                if (!memberKey.equals(memberKeyArray[i])) continue;
                this._addMixOvers(method, this._creatorMethods.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addMemberMethods(Class<?> clazz, AnnotatedMethodMap annotatedMethodMap, Class<?> clazz2, AnnotatedMethodMap annotatedMethodMap2) {
        if (clazz2 != null) {
            this._addMethodMixIns(clazz, annotatedMethodMap, clazz2, annotatedMethodMap2);
        }
        if (clazz == null) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this._isIncludableMemberMethod(method)) continue;
            AnnotatedMethod annotatedMethod = annotatedMethodMap.find(method);
            if (annotatedMethod == null) {
                AnnotatedMethod annotatedMethod2 = this._constructMethod(method);
                annotatedMethodMap.add(annotatedMethod2);
                annotatedMethod = annotatedMethodMap2.remove(method);
                if (annotatedMethod == null) continue;
                this._addMixOvers(annotatedMethod.getAnnotated(), annotatedMethod2, false);
                continue;
            }
            this._addMixUnders(method, annotatedMethod);
            if (!annotatedMethod.getDeclaringClass().isInterface() || method.getDeclaringClass().isInterface()) continue;
            annotatedMethodMap.add(annotatedMethod.withMethod(method));
        }
    }

    protected void _addMethodMixIns(Class<?> clazz, AnnotatedMethodMap annotatedMethodMap, Class<?> clazz2, AnnotatedMethodMap annotatedMethodMap2) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(clazz2);
        ClassUtil.findSuperTypes(clazz2, clazz, arrayList);
        for (Class clazz3 : arrayList) {
            for (Method method : clazz3.getDeclaredMethods()) {
                if (!this._isIncludableMemberMethod(method)) continue;
                AnnotatedMethod annotatedMethod = annotatedMethodMap.find(method);
                if (annotatedMethod != null) {
                    this._addMixUnders(method, annotatedMethod);
                    continue;
                }
                annotatedMethodMap2.add(this._constructMethod(method));
            }
        }
    }

    protected Map<String, AnnotatedField> _findFields(Class<?> clazz, Map<String, AnnotatedField> map) {
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            map = this._findFields(clazz2, map);
            Object object = clazz.getDeclaredFields();
            int n = ((Field[])object).length;
            for (int i = 0; i < n; ++i) {
                Field field = object[i];
                if (!this._isIncludableField(field)) continue;
                if (map == null) {
                    map = new LinkedHashMap<String, AnnotatedField>();
                }
                map.put(field.getName(), this._constructField(field));
            }
            if (this._mixInResolver != null && (object = this._mixInResolver.findMixInClassFor(clazz)) != null) {
                this._addFieldMixIns(clazz2, (Class<?>)object, map);
            }
        }
        return map;
    }

    protected void _addFieldMixIns(Class<?> clazz, Class<?> clazz2, Map<String, AnnotatedField> map) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(clazz2);
        ClassUtil.findSuperTypes(clazz2, clazz, arrayList);
        for (Class clazz3 : arrayList) {
            for (Field field : clazz3.getDeclaredFields()) {
                String string;
                AnnotatedField annotatedField;
                if (!this._isIncludableField(field) || (annotatedField = map.get(string = field.getName())) == null) continue;
                this._addOrOverrideAnnotations(annotatedField, field.getDeclaredAnnotations());
            }
        }
    }

    protected AnnotatedMethod _constructMethod(Method method) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(method, this._emptyAnnotationMap(), null);
        }
        return new AnnotatedMethod(method, this._collectRelevantAnnotations(method.getDeclaredAnnotations()), null);
    }

    protected AnnotatedConstructor _constructConstructor(Constructor<?> constructor, boolean bl) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(constructor, this._emptyAnnotationMap(), this._emptyAnnotationMaps(constructor.getParameterTypes().length));
        }
        if (bl) {
            return new AnnotatedConstructor(constructor, this._collectRelevantAnnotations(constructor.getDeclaredAnnotations()), null);
        }
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        int n = constructor.getParameterTypes().length;
        AnnotationMap[] annotationMapArray = null;
        if (n != annotationArray.length) {
            Class<?> clazz = constructor.getDeclaringClass();
            if (clazz.isEnum() && n == annotationArray.length + 2) {
                Annotation[][] annotationArray2 = annotationArray;
                annotationArray = new Annotation[annotationArray2.length + 2][];
                System.arraycopy(annotationArray2, 0, annotationArray, 2, annotationArray2.length);
                annotationMapArray = this._collectRelevantAnnotations(annotationArray);
            } else if (clazz.isMemberClass() && n == annotationArray.length + 1) {
                Annotation[][] annotationArray3 = annotationArray;
                annotationArray = new Annotation[annotationArray3.length + 1][];
                System.arraycopy(annotationArray3, 0, annotationArray, 1, annotationArray3.length);
                annotationMapArray = this._collectRelevantAnnotations(annotationArray);
            }
            if (annotationMapArray == null) {
                throw new IllegalStateException("Internal error: constructor for " + constructor.getDeclaringClass().getName() + " has mismatch: " + n + " parameters; " + annotationArray.length + " sets of annotations");
            }
        } else {
            annotationMapArray = this._collectRelevantAnnotations(annotationArray);
        }
        return new AnnotatedConstructor(constructor, this._collectRelevantAnnotations(constructor.getDeclaredAnnotations()), annotationMapArray);
    }

    protected AnnotatedMethod _constructCreatorMethod(Method method) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(method, this._emptyAnnotationMap(), this._emptyAnnotationMaps(method.getParameterTypes().length));
        }
        return new AnnotatedMethod(method, this._collectRelevantAnnotations(method.getDeclaredAnnotations()), this._collectRelevantAnnotations(method.getParameterAnnotations()));
    }

    protected AnnotatedField _constructField(Field field) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedField(field, this._emptyAnnotationMap());
        }
        return new AnnotatedField(field, this._collectRelevantAnnotations(field.getDeclaredAnnotations()));
    }

    private AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    private AnnotationMap[] _emptyAnnotationMaps(int n) {
        if (n == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] annotationMapArray = new AnnotationMap[n];
        for (int i = 0; i < n; ++i) {
            annotationMapArray[i] = this._emptyAnnotationMap();
        }
        return annotationMapArray;
    }

    protected boolean _isIncludableMemberMethod(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.isSynthetic() || method.isBridge()) {
            return false;
        }
        int n = method.getParameterTypes().length;
        return n <= 2;
    }

    private boolean _isIncludableField(Field field) {
        if (field.isSynthetic()) {
            return false;
        }
        int n = field.getModifiers();
        return !Modifier.isStatic(n) && !Modifier.isTransient(n);
    }

    protected AnnotationMap[] _collectRelevantAnnotations(Annotation[][] annotationArray) {
        int n = annotationArray.length;
        AnnotationMap[] annotationMapArray = new AnnotationMap[n];
        for (int i = 0; i < n; ++i) {
            annotationMapArray[i] = this._collectRelevantAnnotations(annotationArray[i]);
        }
        return annotationMapArray;
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] annotationArray) {
        AnnotationMap annotationMap = new AnnotationMap();
        this._addAnnotationsIfNotPresent(annotationMap, annotationArray);
        return annotationMap;
    }

    private void _addAnnotationsIfNotPresent(AnnotationMap annotationMap, Annotation[] annotationArray) {
        if (annotationArray != null) {
            LinkedList<Annotation[]> linkedList = null;
            for (Annotation annotation : annotationArray) {
                if (this._isAnnotationBundle(annotation)) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Annotation[]>();
                    }
                    linkedList.add(annotation.annotationType().getDeclaredAnnotations());
                    continue;
                }
                annotationMap.addIfNotPresent(annotation);
            }
            if (linkedList != null) {
                for (Annotation[] annotationArray2 : linkedList) {
                    this._addAnnotationsIfNotPresent(annotationMap, annotationArray2);
                }
            }
        }
    }

    private void _addAnnotationsIfNotPresent(AnnotatedMember annotatedMember, Annotation[] annotationArray) {
        if (annotationArray != null) {
            LinkedList<Annotation[]> linkedList = null;
            for (Annotation annotation : annotationArray) {
                if (this._isAnnotationBundle(annotation)) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Annotation[]>();
                    }
                    linkedList.add(annotation.annotationType().getDeclaredAnnotations());
                    continue;
                }
                annotatedMember.addIfNotPresent(annotation);
            }
            if (linkedList != null) {
                for (Annotation[] annotationArray2 : linkedList) {
                    this._addAnnotationsIfNotPresent(annotatedMember, annotationArray2);
                }
            }
        }
    }

    private void _addOrOverrideAnnotations(AnnotatedMember annotatedMember, Annotation[] annotationArray) {
        if (annotationArray != null) {
            LinkedList<Annotation[]> linkedList = null;
            for (Annotation annotation : annotationArray) {
                if (this._isAnnotationBundle(annotation)) {
                    if (linkedList == null) {
                        linkedList = new LinkedList<Annotation[]>();
                    }
                    linkedList.add(annotation.annotationType().getDeclaredAnnotations());
                    continue;
                }
                annotatedMember.addOrOverride(annotation);
            }
            if (linkedList != null) {
                for (Annotation[] annotationArray2 : linkedList) {
                    this._addOrOverrideAnnotations(annotatedMember, annotationArray2);
                }
            }
        }
    }

    protected void _addMixOvers(Constructor<?> constructor, AnnotatedConstructor annotatedConstructor, boolean bl) {
        this._addOrOverrideAnnotations(annotatedConstructor, constructor.getDeclaredAnnotations());
        if (bl) {
            Annotation[][] annotationArray = constructor.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                for (Annotation annotation : annotationArray[i]) {
                    annotatedConstructor.addOrOverrideParam(i, annotation);
                }
            }
        }
    }

    protected void _addMixOvers(Method method, AnnotatedMethod annotatedMethod, boolean bl) {
        this._addOrOverrideAnnotations(annotatedMethod, method.getDeclaredAnnotations());
        if (bl) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                for (Annotation annotation : annotationArray[i]) {
                    annotatedMethod.addOrOverrideParam(i, annotation);
                }
            }
        }
    }

    protected void _addMixUnders(Method method, AnnotatedMethod annotatedMethod) {
        this._addAnnotationsIfNotPresent(annotatedMethod, method.getDeclaredAnnotations());
    }

    private final boolean _isAnnotationBundle(Annotation annotation) {
        return this._annotationIntrospector != null && this._annotationIntrospector.isAnnotationBundle(annotation);
    }

    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }
}

