/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.ext;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;

public abstract class DOMDeserializer<T>
extends FromStringDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private static final DocumentBuilderFactory _parserFactory = DocumentBuilderFactory.newInstance();

    protected DOMDeserializer(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public abstract T _deserialize(String var1, DeserializationContext var2);

    protected final Document parse(String string) throws IllegalArgumentException {
        try {
            return _parserFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Failed to parse JSON String as XML: " + exception.getMessage(), exception);
        }
    }

    static {
        _parserFactory.setNamespaceAware(true);
    }

    public static class DocumentDeserializer
    extends DOMDeserializer<Document> {
        private static final long serialVersionUID = 1L;

        public DocumentDeserializer() {
            super(Document.class);
        }

        @Override
        public Document _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return this.parse(string);
        }
    }

    public static class NodeDeserializer
    extends DOMDeserializer<Node> {
        private static final long serialVersionUID = 1L;

        public NodeDeserializer() {
            super(Node.class);
        }

        @Override
        public Node _deserialize(String string, DeserializationContext deserializationContext) throws IllegalArgumentException {
            return this.parse(string);
        }
    }
}

