/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.core.JsonToken;
import shaded.com.fasterxml.jackson.databind.DeserializationContext;
import shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import shaded.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import shaded.com.fasterxml.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer<Class<?>> {
    private static final long serialVersionUID = 1L;
    public static final ClassDeserializer instance = new ClassDeserializer();

    public ClassDeserializer() {
        super(Class.class);
    }

    @Override
    public Class<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                return deserializationContext.findClass(string);
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._valueClass, ClassUtil.getRootCause(exception));
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

