/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.core.io;

import java.io.Writer;
import shaded.com.fasterxml.jackson.core.util.BufferRecycler;
import shaded.com.fasterxml.jackson.core.util.TextBuffer;

public final class SegmentedStringWriter
extends Writer {
    protected final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler bufferRecycler) {
        this._buffer = new TextBuffer(bufferRecycler);
    }

    @Override
    public Writer append(char c) {
        this.write(c);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        String string = charSequence.toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        String string = charSequence.subSequence(n, n2).toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cArray) {
        this._buffer.append(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this._buffer.append(cArray, n, n2);
    }

    @Override
    public void write(int n) {
        this._buffer.append((char)n);
    }

    @Override
    public void write(String string) {
        this._buffer.append(string, 0, string.length());
    }

    @Override
    public void write(String string, int n, int n2) {
        this._buffer.append(string, n, n2);
    }

    public String getAndClear() {
        String string = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return string;
    }
}

