/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.fasterxml.jackson.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import shaded.com.fasterxml.jackson.core.io.IOContext;

abstract class BaseReader
extends Reader {
    protected static final int LAST_VALID_UNICODE_CHAR = 0x10FFFF;
    protected static final char NULL_CHAR = '\u0000';
    protected static final char NULL_BYTE = '\u0000';
    protected final IOContext _context;
    protected InputStream _in;
    protected byte[] _buffer;
    protected int _ptr;
    protected int _length;
    protected char[] _tmpBuf = null;

    protected BaseReader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = inputStream;
        this._buffer = byArray;
        this._ptr = n;
        this._length = n2;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this._in;
        if (inputStream != null) {
            this._in = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuf == null) {
            this._tmpBuf = new char[1];
        }
        if (this.read(this._tmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuf[0];
    }

    public final void freeBuffers() {
        byte[] byArray = this._buffer;
        if (byArray != null) {
            this._buffer = null;
            this._context.releaseReadIOBuffer(byArray);
        }
    }

    protected void reportBounds(char[] cArray, int n, int n2) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n + "," + n2 + "), cbuf[" + cArray.length + "]");
    }

    protected void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

