/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.pipes.util.iterators;

import com.tinkerpop.pipes.util.iterators.EmptyIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class ExpandableIterator<T>
implements Iterator<T> {
    private final Queue<T> queue = new LinkedList<T>();
    private final Iterator<T> iterator;

    public ExpandableIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public ExpandableIterator() {
        this.iterator = EmptyIterator.INSTANCE;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        if (this.queue.isEmpty()) {
            return this.iterator.next();
        }
        return this.queue.remove();
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty() || this.iterator.hasNext();
    }

    public void add(T t) {
        this.queue.add(t);
    }
}

