/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.java;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.Tokens;
import com.tinkerpop.gremlin.java.GremlinFluentPipeline;
import com.tinkerpop.gremlin.java.GremlinFluentUtility;
import com.tinkerpop.gremlin.java.GremlinStartPipe;
import com.tinkerpop.pipes.FunctionPipe;
import com.tinkerpop.pipes.IdentityPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.branch.CopySplitPipe;
import com.tinkerpop.pipes.branch.ExhaustMergePipe;
import com.tinkerpop.pipes.branch.FairMergePipe;
import com.tinkerpop.pipes.branch.IfThenElsePipe;
import com.tinkerpop.pipes.branch.LoopPipe;
import com.tinkerpop.pipes.filter.AndFilterPipe;
import com.tinkerpop.pipes.filter.BackFilterPipe;
import com.tinkerpop.pipes.filter.CyclicPathFilterPipe;
import com.tinkerpop.pipes.filter.DuplicateFilterPipe;
import com.tinkerpop.pipes.filter.ExceptFilterPipe;
import com.tinkerpop.pipes.filter.FilterFunctionPipe;
import com.tinkerpop.pipes.filter.IdFilterPipe;
import com.tinkerpop.pipes.filter.IntervalFilterPipe;
import com.tinkerpop.pipes.filter.LabelFilterPipe;
import com.tinkerpop.pipes.filter.OrFilterPipe;
import com.tinkerpop.pipes.filter.PropertyFilterPipe;
import com.tinkerpop.pipes.filter.RandomFilterPipe;
import com.tinkerpop.pipes.filter.RangeFilterPipe;
import com.tinkerpop.pipes.filter.RetainFilterPipe;
import com.tinkerpop.pipes.sideeffect.AggregatePipe;
import com.tinkerpop.pipes.sideeffect.GroupByPipe;
import com.tinkerpop.pipes.sideeffect.GroupByReducePipe;
import com.tinkerpop.pipes.sideeffect.GroupCountFunctionPipe;
import com.tinkerpop.pipes.sideeffect.GroupCountPipe;
import com.tinkerpop.pipes.sideeffect.LinkPipe;
import com.tinkerpop.pipes.sideeffect.OptionalPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectFunctionPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.sideeffect.StorePipe;
import com.tinkerpop.pipes.sideeffect.TablePipe;
import com.tinkerpop.pipes.sideeffect.TreePipe;
import com.tinkerpop.pipes.transform.BothEdgesPipe;
import com.tinkerpop.pipes.transform.BothPipe;
import com.tinkerpop.pipes.transform.BothVerticesPipe;
import com.tinkerpop.pipes.transform.GatherFunctionPipe;
import com.tinkerpop.pipes.transform.GatherPipe;
import com.tinkerpop.pipes.transform.GraphQueryPipe;
import com.tinkerpop.pipes.transform.IdEdgePipe;
import com.tinkerpop.pipes.transform.IdPipe;
import com.tinkerpop.pipes.transform.IdVertexPipe;
import com.tinkerpop.pipes.transform.InEdgesPipe;
import com.tinkerpop.pipes.transform.InPipe;
import com.tinkerpop.pipes.transform.InVertexPipe;
import com.tinkerpop.pipes.transform.LabelPipe;
import com.tinkerpop.pipes.transform.MemoizePipe;
import com.tinkerpop.pipes.transform.OrderMapPipe;
import com.tinkerpop.pipes.transform.OrderPipe;
import com.tinkerpop.pipes.transform.OutEdgesPipe;
import com.tinkerpop.pipes.transform.OutPipe;
import com.tinkerpop.pipes.transform.OutVertexPipe;
import com.tinkerpop.pipes.transform.PathPipe;
import com.tinkerpop.pipes.transform.PropertyMapPipe;
import com.tinkerpop.pipes.transform.PropertyPipe;
import com.tinkerpop.pipes.transform.ScatterPipe;
import com.tinkerpop.pipes.transform.SelectPipe;
import com.tinkerpop.pipes.transform.ShufflePipe;
import com.tinkerpop.pipes.transform.SideEffectCapPipe;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.transform.VertexQueryPipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.FluentUtility;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.Pipeline;
import com.tinkerpop.pipes.util.StartPipe;
import com.tinkerpop.pipes.util.structures.AsMap;
import com.tinkerpop.pipes.util.structures.Pair;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import com.tinkerpop.pipes.util.structures.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GremlinPipeline<S, E>
extends Pipeline<S, E>
implements GremlinFluentPipeline<S, E> {
    private boolean doQueryOptimization = true;
    protected final AsMap asMap = new AsMap(this);

    public GremlinPipeline() {
    }

    public GremlinPipeline(Object starts, boolean doQueryOptimization) {
        super(new GremlinStartPipe(starts));
        this.doQueryOptimization = doQueryOptimization;
        FluentUtility.setStarts(this, starts);
    }

    public GremlinPipeline(Object starts) {
        this(starts, true);
    }

    public <T> GremlinPipeline<S, T> add(Pipe<?, T> pipe) {
        this.addPipe(pipe);
        return this;
    }

    public GremlinPipeline<S, Vertex> V() {
        return this.add(new GraphQueryPipe<Vertex>(Vertex.class));
    }

    public GremlinPipeline<S, Edge> E() {
        return this.add(new GraphQueryPipe<Edge>(Edge.class));
    }

    public GremlinPipeline<S, Vertex> V(String key, Object value) {
        return this.add(new GraphQueryPipe<Vertex>(Vertex.class)).has(key, value);
    }

    public GremlinPipeline<S, Edge> E(String key, Object value) {
        return this.add(new GraphQueryPipe<Edge>(Edge.class)).has(key, value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key) {
        return this.has(key, Tokens.T.neq, null);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key, Object value) {
        return this.has(key, Tokens.T.eq, value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key, Tokens.T compareToken, Object value) {
        return this.has(key, Tokens.mapPredicate(compareToken), value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key, Predicate predicate, Object value) {
        if (key.equals("id")) {
            return this.add(new IdFilterPipe(predicate, value));
        }
        if (key.equals("label")) {
            return this.add(new LabelFilterPipe(predicate, value));
        }
        PropertyFilterPipe pipe = new PropertyFilterPipe(key, predicate, value);
        return this.doQueryOptimization ? GremlinFluentUtility.optimizePipelineForQuery(this, pipe) : this.add(pipe);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> hasNot(String key) {
        return this.has(key, Tokens.T.eq, null);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> hasNot(String key, Object value) {
        return this.has(key, Tokens.T.neq, value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> interval(String key, Comparable startValue, Comparable endValue) {
        IntervalFilterPipe pipe = new IntervalFilterPipe(key, startValue, endValue);
        return this.doQueryOptimization ? GremlinFluentUtility.optimizePipelineForQuery(this, pipe) : this.add(pipe);
    }

    @Override
    public GremlinPipeline<S, Edge> bothE(String ... labels) {
        return this.bothE(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Edge> bothE(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add(new VertexQueryPipe<Edge>(Edge.class, Direction.BOTH, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add(new BothEdgesPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> both(String ... labels) {
        return this.both(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Vertex> both(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add(new VertexQueryPipe<Vertex>(Vertex.class, Direction.BOTH, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add(new BothPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> bothV() {
        return this.add(new BothVerticesPipe());
    }

    @Override
    public GremlinPipeline<S, Edge> idEdge(Graph graph) {
        return this.add(new IdEdgePipe(graph));
    }

    @Override
    public GremlinPipeline<S, Object> id() {
        return this.add(new IdPipe());
    }

    @Override
    public GremlinPipeline<S, Vertex> idVertex(Graph graph) {
        return this.add(new IdVertexPipe(graph));
    }

    @Override
    public GremlinPipeline<S, Edge> inE(String ... labels) {
        return this.inE(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Edge> inE(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add(new VertexQueryPipe<Edge>(Edge.class, Direction.IN, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add(new InEdgesPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> in(String ... labels) {
        return this.in(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Vertex> in(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add(new VertexQueryPipe<Vertex>(Vertex.class, Direction.IN, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add(new InPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> inV() {
        return this.add(new InVertexPipe());
    }

    @Override
    public GremlinPipeline<S, String> label() {
        return this.add(new LabelPipe());
    }

    @Override
    public GremlinPipeline<S, Edge> outE(String ... labels) {
        return this.outE(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Edge> outE(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add(new VertexQueryPipe<Edge>(Edge.class, Direction.OUT, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add(new OutEdgesPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> out(String ... labels) {
        return this.out(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Vertex> out(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add(new VertexQueryPipe<Vertex>(Vertex.class, Direction.OUT, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add(new OutPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> outV() {
        return this.add(new OutVertexPipe());
    }

    @Override
    public GremlinPipeline<S, Map<String, Object>> map(String ... keys) {
        return this.add(new PropertyMapPipe(keys));
    }

    @Override
    public GremlinPipeline<S, Object> property(String key) {
        return this.add(new PropertyPipe(key));
    }

    @Override
    public GremlinPipeline<S, ?> step(PipeFunction function) {
        return this.add(new FunctionPipe(FluentUtility.prepareFunction(this.asMap, function)));
    }

    @Override
    public <T> GremlinPipeline<S, T> step(Pipe<E, T> pipe) {
        return this.add(pipe);
    }

    @Override
    public GremlinPipeline<S, ?> copySplit(Pipe<E, ?> ... pipes) {
        return this.add(new CopySplitPipe(pipes));
    }

    @Override
    public GremlinPipeline<S, ?> exhaustMerge() {
        return this.add(new ExhaustMergePipe(((MetaPipe)((Object)FluentUtility.getPreviousPipe(this))).getPipes()));
    }

    @Override
    public GremlinPipeline<S, ?> fairMerge() {
        return this.add(new FairMergePipe(((MetaPipe)((Object)FluentUtility.getPreviousPipe(this))).getPipes()));
    }

    @Override
    public GremlinPipeline<S, ?> ifThenElse(PipeFunction<E, Boolean> ifFunction, PipeFunction<E, ?> thenFunction, PipeFunction<E, ?> elseFunction) {
        return this.add(new IfThenElsePipe(FluentUtility.prepareFunction(this.asMap, ifFunction), FluentUtility.prepareFunction(this.asMap, thenFunction), FluentUtility.prepareFunction(this.asMap, elseFunction)));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> loop(int numberedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction) {
        return this.add(new LoopPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, numberedStep)), FluentUtility.prepareFunction(this.asMap, whileFunction)));
    }

    @Override
    public GremlinPipeline<S, E> loop(String namedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction) {
        return this.add(new LoopPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, namedStep)), FluentUtility.prepareFunction(this.asMap, whileFunction)));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> loop(int numberedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> emitFunction) {
        return this.add(new LoopPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, numberedStep)), FluentUtility.prepareFunction(this.asMap, whileFunction), FluentUtility.prepareFunction(this.asMap, emitFunction)));
    }

    @Override
    public GremlinPipeline<S, E> loop(String namedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> emitFunction) {
        return this.add(new LoopPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, namedStep)), FluentUtility.prepareFunction(this.asMap, whileFunction), FluentUtility.prepareFunction(this.asMap, emitFunction)));
    }

    @Override
    public GremlinPipeline<S, E> and(Pipe<E, ?> ... pipes) {
        return this.add(new AndFilterPipe<E>(pipes));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, ?> back(int numberedStep) {
        return this.add(new BackFilterPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, numberedStep))));
    }

    @Override
    public GremlinPipeline<S, ?> back(String namedStep) {
        return this.add(new BackFilterPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, namedStep))));
    }

    @Override
    public GremlinPipeline<S, E> dedup() {
        return this.add(new DuplicateFilterPipe());
    }

    @Override
    public GremlinPipeline<S, E> dedup(PipeFunction<E, ?> dedupFunction) {
        return this.add(new DuplicateFilterPipe(FluentUtility.prepareFunction(this.asMap, dedupFunction)));
    }

    @Override
    public GremlinPipeline<S, E> except(Collection<E> collection) {
        return this.add(new ExceptFilterPipe<E>(collection));
    }

    @Override
    public GremlinPipeline<S, E> except(String ... namedSteps) {
        return this.add(new ExceptFilterPipe(this.asMap, namedSteps));
    }

    @Override
    public GremlinPipeline<S, E> filter(PipeFunction<E, Boolean> filterFunction) {
        return this.add(new FilterFunctionPipe(FluentUtility.prepareFunction(this.asMap, filterFunction)));
    }

    @Override
    public GremlinPipeline<S, E> or(Pipe<E, ?> ... pipes) {
        return this.add(new OrFilterPipe<E>(pipes));
    }

    @Override
    public GremlinPipeline<S, E> random(Double bias) {
        return this.add(new RandomFilterPipe(bias));
    }

    @Override
    public GremlinPipeline<S, E> range(int low, int high) {
        RangeFilterPipe pipe = new RangeFilterPipe(low, high);
        if (!this.doQueryOptimization) {
            return this.add(pipe);
        }
        return GremlinFluentUtility.optimizePipelineForQuery(this, pipe);
    }

    @Override
    public GremlinPipeline<S, E> retain(Collection<E> collection) {
        return this.add(new RetainFilterPipe<E>(collection));
    }

    @Override
    public GremlinPipeline<S, E> retain(String ... namedSteps) {
        return this.add(new RetainFilterPipe(this.asMap, namedSteps));
    }

    @Override
    public GremlinPipeline<S, E> simplePath() {
        return this.add(new CyclicPathFilterPipe());
    }

    @Override
    public GremlinPipeline<S, E> aggregate() {
        return this.aggregate((Collection)new ArrayList());
    }

    @Override
    public GremlinPipeline<S, E> aggregate(Collection<E> aggregate) {
        return this.add(new AggregatePipe(aggregate));
    }

    @Override
    public GremlinPipeline<S, E> aggregate(Collection aggregate, PipeFunction<E, ?> aggregateFunction) {
        return this.add(new AggregatePipe(aggregate, FluentUtility.prepareFunction(this.asMap, aggregateFunction)));
    }

    @Override
    public GremlinPipeline<S, E> aggregate(PipeFunction<E, ?> aggregateFunction) {
        return this.aggregate((Collection)new ArrayList(), FluentUtility.prepareFunction(this.asMap, aggregateFunction));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, ?> optional(int numberedStep) {
        return this.add(new OptionalPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, numberedStep))));
    }

    @Override
    public GremlinPipeline<S, ?> optional(String namedStep) {
        return this.add(new OptionalPipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, namedStep))));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(Map<?, List<?>> map, PipeFunction keyFunction, PipeFunction valueFunction) {
        return this.add(new GroupByPipe(map, FluentUtility.prepareFunction(this.asMap, keyFunction), FluentUtility.prepareFunction(this.asMap, valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(PipeFunction keyFunction, PipeFunction valueFunction) {
        return this.add(new GroupByPipe(FluentUtility.prepareFunction(this.asMap, keyFunction), FluentUtility.prepareFunction(this.asMap, valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(Map reduceMap, PipeFunction keyFunction, PipeFunction valueFunction, PipeFunction reduceFunction) {
        return this.add(new GroupByReducePipe(reduceMap, FluentUtility.prepareFunction(this.asMap, keyFunction), FluentUtility.prepareFunction(this.asMap, valueFunction), FluentUtility.prepareFunction(this.asMap, reduceFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(PipeFunction keyFunction, PipeFunction valueFunction, PipeFunction reduceFunction) {
        return this.add(new GroupByReducePipe(FluentUtility.prepareFunction(this.asMap, keyFunction), FluentUtility.prepareFunction(this.asMap, valueFunction), FluentUtility.prepareFunction(this.asMap, reduceFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(Map<?, Number> map, PipeFunction keyFunction, PipeFunction<Pair<?, Number>, Number> valueFunction) {
        return this.add(new GroupCountFunctionPipe(map, FluentUtility.prepareFunction(this.asMap, keyFunction), FluentUtility.prepareFunction(this.asMap, valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(PipeFunction keyFunction, PipeFunction<Pair<?, Number>, Number> valueFunction) {
        return this.add(new GroupCountFunctionPipe(FluentUtility.prepareFunction(this.asMap, keyFunction), FluentUtility.prepareFunction(this.asMap, valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(Map<?, Number> map, PipeFunction keyFunction) {
        return this.add(new GroupCountFunctionPipe(map, FluentUtility.prepareFunction(this.asMap, keyFunction), null));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(PipeFunction keyFunction) {
        return this.add(new GroupCountFunctionPipe(FluentUtility.prepareFunction(this.asMap, keyFunction), null));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(Map<?, Number> map) {
        return this.add(new GroupCountPipe(map));
    }

    @Override
    public GremlinPipeline<S, E> groupCount() {
        return this.add(new GroupCountPipe());
    }

    @Override
    public GremlinPipeline<S, Vertex> linkOut(String label, String namedStep) {
        return this.add(new LinkPipe(Direction.OUT, label, FluentUtility.getAsPipe(this, namedStep)));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkIn(String label, String namedStep) {
        return this.add(new LinkPipe(Direction.IN, label, FluentUtility.getAsPipe(this, namedStep)));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkBoth(String label, String namedStep) {
        return this.add(new LinkPipe(Direction.BOTH, label, FluentUtility.getAsPipe(this, namedStep)));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkOut(String label, Vertex other) {
        return this.add(new LinkPipe(Direction.OUT, label, other));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkIn(String label, Vertex other) {
        return this.add(new LinkPipe(Direction.IN, label, other));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkBoth(String label, Vertex other) {
        return this.add(new LinkPipe(Direction.BOTH, label, other));
    }

    @Override
    public GremlinPipeline<S, E> sideEffect(PipeFunction<E, ?> sideEffectFunction) {
        return this.add(new SideEffectFunctionPipe(FluentUtility.prepareFunction(this.asMap, sideEffectFunction)));
    }

    @Override
    public GremlinPipeline<S, E> store(Collection<E> storage) {
        return this.add(new StorePipe(storage));
    }

    @Override
    public GremlinPipeline<S, E> store(Collection storage, PipeFunction<E, ?> storageFunction) {
        return this.add(new StorePipe(storage, FluentUtility.prepareFunction(this.asMap, storageFunction)));
    }

    @Override
    public GremlinPipeline<S, E> store() {
        return this.store((Collection)new ArrayList());
    }

    @Override
    public GremlinPipeline<S, E> store(PipeFunction<E, ?> storageFunction) {
        return this.store((Collection)new ArrayList(), FluentUtility.prepareFunction(this.asMap, storageFunction));
    }

    @Override
    public GremlinPipeline<S, E> table(Table table, Collection<String> stepNames, PipeFunction ... columnFunctions) {
        return this.add(new TablePipe(table, stepNames, FluentUtility.getAsPipes(this), FluentUtility.prepareFunctions(this.asMap, columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> table(Table table, PipeFunction ... columnFunctions) {
        return this.add(new TablePipe(table, null, FluentUtility.getAsPipes(this), FluentUtility.prepareFunctions(this.asMap, columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> table(PipeFunction ... columnFunctions) {
        return this.add(new TablePipe(new Table(), null, FluentUtility.getAsPipes(this), FluentUtility.prepareFunctions(this.asMap, columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> table(Table table) {
        return this.add(new TablePipe(table, null, FluentUtility.getAsPipes(this), new PipeFunction[0]));
    }

    @Override
    public GremlinPipeline<S, E> table() {
        return this.add(new TablePipe(new Table(), null, FluentUtility.getAsPipes(this), new PipeFunction[0]));
    }

    @Override
    public GremlinPipeline<S, E> tree(Tree tree, PipeFunction ... branchFunctions) {
        return this.add(new TreePipe(tree, FluentUtility.prepareFunctions(this.asMap, branchFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> tree(PipeFunction ... branchFunctions) {
        return this.add(new TreePipe(FluentUtility.prepareFunctions(this.asMap, branchFunctions)));
    }

    @Override
    public GremlinPipeline<S, List> gather() {
        return this.add(new GatherPipe());
    }

    @Override
    public GremlinPipeline<S, ?> gather(PipeFunction<List, ?> function) {
        return this.add(new GatherFunctionPipe(FluentUtility.prepareFunction(this.asMap, function)));
    }

    @Override
    public GremlinPipeline<S, E> _() {
        return this.add(new IdentityPipe());
    }

    @Override
    public GremlinPipeline<S, E> memoize(String namedStep) {
        return this.add(new MemoizePipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, namedStep))));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> memoize(int numberedStep) {
        return this.add(new MemoizePipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, numberedStep))));
    }

    @Override
    public GremlinPipeline<S, E> memoize(String namedStep, Map map) {
        return this.add(new MemoizePipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, namedStep)), map));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> memoize(int numberedStep, Map map) {
        return this.add(new MemoizePipe(new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, numberedStep)), map));
    }

    @Override
    public GremlinPipeline<S, E> order() {
        return this.add(new OrderPipe());
    }

    @Override
    public GremlinPipeline<S, E> order(TransformPipe.Order order) {
        return this.add(new OrderPipe(order));
    }

    public GremlinPipeline<S, E> order(Tokens.T order) {
        return this.add(new OrderPipe(Tokens.mapOrder(order)));
    }

    @Override
    public GremlinPipeline<S, E> order(PipeFunction<Pair<E, E>, Integer> compareFunction) {
        return this.add(new OrderPipe(FluentUtility.prepareFunction(this.asMap, compareFunction)));
    }

    @Override
    public GremlinPipeline<S, List> path(PipeFunction ... pathFunctions) {
        return this.add(new PathPipe(FluentUtility.prepareFunctions(this.asMap, pathFunctions)));
    }

    @Override
    public GremlinPipeline<S, ?> scatter() {
        return this.add(new ScatterPipe());
    }

    @Override
    public GremlinPipeline<S, Row> select(Collection<String> stepNames, PipeFunction ... columnFunctions) {
        return this.add(new SelectPipe(stepNames, FluentUtility.getAsPipes(this), FluentUtility.prepareFunctions(this.asMap, columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, Row> select(PipeFunction ... columnFunctions) {
        return this.add(new SelectPipe(null, FluentUtility.getAsPipes(this), FluentUtility.prepareFunctions(this.asMap, columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, Row> select() {
        return this.add(new SelectPipe(null, FluentUtility.getAsPipes(this), new PipeFunction[0]));
    }

    @Override
    public GremlinPipeline<S, List> shuffle() {
        return this.add(new ShufflePipe());
    }

    @Override
    public GremlinPipeline<S, ?> cap() {
        return this.add(new SideEffectCapPipe((SideEffectPipe)FluentUtility.removePreviousPipes((Pipeline)this, 1).get(0)));
    }

    @Override
    public GremlinPipeline<S, ?> orderMap(TransformPipe.Order order) {
        return this.add(new OrderMapPipe(order));
    }

    public GremlinPipeline<S, ?> orderMap(Tokens.T order) {
        return this.orderMap(Tokens.mapOrder(order));
    }

    @Override
    public GremlinPipeline<S, ?> orderMap(PipeFunction<Pair<Map.Entry, Map.Entry>, Integer> compareFunction) {
        return this.add(new OrderMapPipe(FluentUtility.prepareFunction(this.asMap, compareFunction)));
    }

    @Override
    public <T> GremlinPipeline<S, T> transform(PipeFunction<E, T> function) {
        return this.add(new TransformFunctionPipe(FluentUtility.prepareFunction(this.asMap, function)));
    }

    @Override
    public GremlinPipeline<S, E> as(String name) {
        GremlinPipeline pipeline = this.add(new AsPipe(name, FluentUtility.removePreviousPipes((Pipeline)this, 1).get(0)));
        this.asMap.refresh();
        return pipeline;
    }

    @Override
    public GremlinPipeline<S, S> start(S object) {
        this.add(new StartPipe(object));
        FluentUtility.setStarts(this, object);
        return this;
    }

    @Override
    public long count() {
        return PipeHelper.counter(this);
    }

    @Override
    public void iterate() {
        PipeHelper.iterate(this);
    }

    @Override
    public List<E> next(int number) {
        ArrayList list = new ArrayList(number);
        PipeHelper.fillCollection(this, list, number);
        return list;
    }

    @Override
    public List<E> toList() {
        ArrayList list = new ArrayList();
        PipeHelper.fillCollection(this, list);
        return list;
    }

    @Override
    public Collection<E> fill(Collection<E> collection) {
        PipeHelper.fillCollection(this, collection);
        return collection;
    }

    @Override
    public GremlinPipeline<S, E> enablePath() {
        this.enablePath(true);
        return this;
    }

    public GremlinPipeline<S, E> optimize(boolean optimize) {
        this.doQueryOptimization = optimize;
        return this;
    }

    @Override
    public void remove() {
        for (Object object : this) {
            ((Element)object).remove();
        }
    }

    @Override
    public <E> GremlinPipeline<S, E> cast(Class<E> end) {
        return this;
    }
}

