/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.console;

import com.tinkerpop.gremlin.Imports;
import com.tinkerpop.gremlin.groovy.Gremlin;
import com.tinkerpop.gremlin.groovy.console.ErrorHookClosure;
import com.tinkerpop.gremlin.groovy.console.NullResultHookClosure;
import com.tinkerpop.gremlin.groovy.console.PromptClosure;
import com.tinkerpop.gremlin.groovy.console.ResultHookClosure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import jline.History;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.InteractiveShellRunner;

public class Console {
    private static final String HISTORY_FILE = ".gremlin_groovy_history";
    private static final String STANDARD_INPUT_PROMPT = "gremlin> ";
    public static final String STANDARD_RESULT_PROMPT = "==>";
    private static final IO STANDARD_IO = new IO(System.in, System.out, System.err);
    private static final Groovysh GROOVYSH = new Groovysh();

    public Console(String initScriptFile) {
        Console.STANDARD_IO.out.println();
        Console.STANDARD_IO.out.println("         \\,,,/");
        Console.STANDARD_IO.out.println("         (o o)");
        Console.STANDARD_IO.out.println("-----oOOo-(_)-oOOo-----");
        GROOVYSH.setResultHook(new NullResultHookClosure(GROOVYSH));
        for (String imps : Imports.getImports()) {
            GROOVYSH.execute("import " + imps);
        }
        GROOVYSH.execute("import com.tinkerpop.gremlin.Tokens.T");
        GROOVYSH.execute("import com.tinkerpop.gremlin.groovy.*");
        GROOVYSH.execute("import groovy.grape.Grape");
        GROOVYSH.setResultHook(new ResultHookClosure(GROOVYSH, STANDARD_IO, STANDARD_RESULT_PROMPT));
        GROOVYSH.setHistory(new History());
        InteractiveShellRunner runner = new InteractiveShellRunner(GROOVYSH, new PromptClosure((Object)GROOVYSH, STANDARD_INPUT_PROMPT));
        runner.setErrorHandler(new ErrorHookClosure((Object)runner, STANDARD_IO));
        try {
            runner.setHistory(new History(new File(System.getProperty("user.home") + "/" + HISTORY_FILE)));
        }
        catch (IOException e) {
            Console.STANDARD_IO.err.println("Unable to create history file: .gremlin_groovy_history");
        }
        Gremlin.load();
        this.initializeShellWithScript(STANDARD_IO, initScriptFile, GROOVYSH);
        try {
            runner.run();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public static Groovysh getGroovysh() {
        return GROOVYSH;
    }

    public static IO getStandardIo() {
        return STANDARD_IO;
    }

    private void initializeShellWithScript(IO io, String initScriptFile, Groovysh groovy) {
        if (initScriptFile != null) {
            String line = "";
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(initScriptFile), Charset.forName("UTF-8")));
                while ((line = reader.readLine()) != null) {
                    groovy.execute(line);
                }
                reader.close();
            }
            catch (FileNotFoundException fnfe) {
                io.err.println(String.format("Gremlin initialization file not found at [%s].", initScriptFile));
                System.exit(1);
            }
            catch (IOException ioe) {
                io.err.println(String.format("Bad line in Gremlin initialization file at [%s].", line));
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) {
        new Console(args.length == 1 ? args[0] : null);
    }
}

