/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.io.graphson;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphElementFactory;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import shaded.com.fasterxml.jackson.core.JsonFactory;
import shaded.com.fasterxml.jackson.core.JsonParser;
import shaded.com.fasterxml.jackson.core.JsonToken;
import shaded.com.fasterxml.jackson.databind.JsonNode;
import shaded.com.fasterxml.jackson.databind.MappingJsonFactory;

public class GraphSONReader {
    private static final JsonFactory jsonFactory = new MappingJsonFactory();
    private final Graph graph;

    public GraphSONReader(Graph graph) {
        this.graph = graph;
    }

    public void inputGraph(InputStream jsonInputStream) throws IOException {
        GraphSONReader.inputGraph(this.graph, jsonInputStream, 1000);
    }

    public void inputGraph(String filename) throws IOException {
        GraphSONReader.inputGraph(this.graph, filename, 1000);
    }

    public void inputGraph(InputStream jsonInputStream, int bufferSize) throws IOException {
        GraphSONReader.inputGraph(this.graph, jsonInputStream, bufferSize);
    }

    public void inputGraph(String filename, int bufferSize) throws IOException {
        GraphSONReader.inputGraph(this.graph, filename, bufferSize);
    }

    public static void inputGraph(Graph graph, InputStream jsonInputStream) throws IOException {
        GraphSONReader.inputGraph(graph, jsonInputStream, 1000);
    }

    public static void inputGraph(Graph graph, String filename) throws IOException {
        GraphSONReader.inputGraph(graph, filename, 1000);
    }

    public static void inputGraph(Graph inputGraph, InputStream jsonInputStream, int bufferSize) throws IOException {
        GraphSONReader.inputGraph(inputGraph, jsonInputStream, bufferSize, null, null);
    }

    public static void inputGraph(Graph inputGraph, String filename, int bufferSize) throws IOException {
        GraphSONReader.inputGraph(inputGraph, filename, bufferSize, null, null);
    }

    public static void inputGraph(Graph inputGraph, String filename, int bufferSize, Set<String> edgePropertyKeys, Set<String> vertexPropertyKeys) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        GraphSONReader.inputGraph(inputGraph, fis, bufferSize, edgePropertyKeys, vertexPropertyKeys);
        fis.close();
    }

    public static void inputGraph(Graph inputGraph, InputStream jsonInputStream, int bufferSize, Set<String> edgePropertyKeys, Set<String> vertexPropertyKeys) throws IOException {
        JsonParser jp = jsonFactory.createJsonParser(jsonInputStream);
        BatchGraph graph = BatchGraph.wrap(inputGraph, bufferSize);
        GraphElementFactory elementFactory = new GraphElementFactory(graph);
        GraphSONUtility graphson = new GraphSONUtility(GraphSONMode.NORMAL, elementFactory, vertexPropertyKeys, edgePropertyKeys);
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            JsonNode node;
            String fieldname;
            String string = fieldname = jp.getCurrentName() == null ? "" : jp.getCurrentName();
            if (fieldname.equals("mode")) {
                jp.nextToken();
                GraphSONMode mode = GraphSONMode.valueOf(jp.getText());
                graphson = new GraphSONUtility(mode, elementFactory, vertexPropertyKeys, edgePropertyKeys);
                continue;
            }
            if (fieldname.equals("vertices")) {
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    node = (JsonNode)jp.readValueAsTree();
                    graphson.vertexFromJson(node);
                }
                continue;
            }
            if (!fieldname.equals("edges")) continue;
            jp.nextToken();
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                node = (JsonNode)jp.readValueAsTree();
                Vertex inV = graph.getVertex(GraphSONUtility.getTypedValueFromJsonNode(node.get("_inV")));
                Vertex outV = graph.getVertex(GraphSONUtility.getTypedValueFromJsonNode(node.get("_outV")));
                graphson.edgeFromJson(node, outV, inV);
            }
        }
        jp.close();
        graph.commit();
    }
}

