/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.tg;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.Serializable;

class TinkerEdge
extends TinkerElement
implements Edge,
Serializable {
    private final String label;
    private final Vertex inVertex;
    private final Vertex outVertex;

    protected TinkerEdge(String id, Vertex outVertex, Vertex inVertex, String label, TinkerGraph graph) {
        super(id, graph);
        this.label = label;
        this.outVertex = outVertex;
        this.inVertex = inVertex;
        this.graph.edgeKeyIndex.autoUpdate("label", this.label, null, this);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Vertex getVertex(Direction direction) throws IllegalArgumentException {
        if (direction.equals((Object)Direction.IN)) {
            return this.inVertex;
        }
        if (direction.equals((Object)Direction.OUT)) {
            return this.outVertex;
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public String toString() {
        return StringFactory.edgeString(this);
    }
}

