/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtHeader;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtPayload;
import com.orientechnologies.orient.core.metadata.security.jwt.OKeyProvider;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.binary.impl.OBinaryToken;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.orient.server.token.DefaultKeyProvider;
import com.orientechnologies.orient.server.token.JsonWebToken;
import com.orientechnologies.orient.server.token.OBinaryTokenSerializer;
import com.orientechnologies.orient.server.token.OrientJwtHeader;
import com.orientechnologies.orient.server.token.OrientJwtPayload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.UUID;
import javax.crypto.Mac;

public class OrientTokenHandler
extends OServerPluginAbstract
implements OTokenHandler {
    public static final String SIGN_KEY_PAR = "oAuth2Key";
    public static final String SESSION_LENGHT_PAR = "sessionLength";
    public static final String ENCRYPTION_ALGORITHM_PAR = "encryptionAlgorithm";
    public static final String ENCRYPTION_ALGORITHM_DEFAULT = "HmacSHA256";
    private static String algorithm = "HmacSHA256";
    private static final ThreadLocal<Mac> threadLocalMac = new MacThreadLocal();
    protected static final int JWT_DELIMITER = 46;
    private boolean enabled = false;
    private OBinaryTokenSerializer binarySerializer;
    private long sessionInMills = 3600000L;
    private OKeyProvider keyProvider;

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (!Boolean.parseBoolean(param.value)) continue;
                this.enabled = true;
                continue;
            }
            if (param.name.equalsIgnoreCase(SIGN_KEY_PAR)) {
                byte[] secret = OBase64Utils.decode(param.value, 16);
                this.keyProvider = new DefaultKeyProvider(secret);
                continue;
            }
            if (param.name.equalsIgnoreCase(SESSION_LENGHT_PAR)) {
                this.sessionInMills = Long.parseLong(param.value) * 1000L * 60L;
                continue;
            }
            if (!param.name.equalsIgnoreCase(ENCRYPTION_ALGORITHM_PAR)) continue;
            algorithm = param.value;
            try {
                Mac.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new IllegalArgumentException("Can't find encryption algorithm '" + algorithm + "'", nsa);
            }
        }
        String[] keys = this.keyProvider.getKeys();
        this.binarySerializer = new OBinaryTokenSerializer(new String[]{"plocal", "memory"}, keys, new String[]{algorithm}, new String[]{"OrientDB"});
    }

    @Override
    public OToken parseWebToken(byte[] tokenBytes) {
        JsonWebToken token = null;
        int firstDot = -1;
        int secondDot = -1;
        for (int x = 0; x < tokenBytes.length; ++x) {
            if (tokenBytes[x] != 46) continue;
            if (firstDot == -1) {
                firstDot = x;
                continue;
            }
            secondDot = x;
            break;
        }
        if (firstDot == -1) {
            throw new RuntimeException("Token data too short: missed header");
        }
        if (secondDot == -1) {
            throw new RuntimeException("Token data too short: missed signature");
        }
        byte[] decodedHeader = OBase64Utils.decode(tokenBytes, 0, firstDot, 16);
        byte[] decodedPayload = OBase64Utils.decode(tokenBytes, firstDot + 1, secondDot - (firstDot + 1), 16);
        byte[] decodedSignature = OBase64Utils.decode(tokenBytes, secondDot + 1, tokenBytes.length - (secondDot + 1), 16);
        OrientJwtHeader header = this.deserializeWebHeader(decodedHeader);
        OJwtPayload deserializeWebPayload = this.deserializeWebPayload(header.getType(), decodedPayload);
        token = new JsonWebToken(header, deserializeWebPayload);
        token.setIsVerified(this.verifyTokenSignature(header, tokenBytes, 0, secondDot, decodedSignature));
        return token;
    }

    @Override
    public boolean validateToken(OToken token, String command, String database) {
        boolean valid = false;
        if (!(token instanceof JsonWebToken)) {
            return false;
        }
        OrientJwtPayload payload = (OrientJwtPayload)((JsonWebToken)token).getPayload();
        if (token.getDatabase().equalsIgnoreCase(database) && token.getExpiry() > System.currentTimeMillis() && payload.getNotBefore() < System.currentTimeMillis()) {
            valid = true;
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public boolean validateBinaryToken(OToken token) {
        boolean valid = false;
        long curTime = System.currentTimeMillis();
        if (token.getExpiry() > curTime && token.getExpiry() - (this.sessionInMills + 1L) < curTime) {
            valid = true;
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public byte[] getSignedWebToken(ODatabaseDocumentInternal db, OSecurityUser user) {
        ByteArrayOutputStream tokenByteOS = new ByteArrayOutputStream(1024);
        OrientJwtHeader header = new OrientJwtHeader();
        header.setAlgorithm("HS256");
        header.setKeyId("");
        OJwtPayload payload = this.createPayload(db, user);
        header.setType(this.getPayloadType(payload));
        try {
            byte[] bytes = this.serializeWebHeader(header);
            tokenByteOS.write(OBase64Utils.encodeBytesToBytes(bytes, 0, bytes.length, 16));
            tokenByteOS.write(46);
            bytes = this.serializeWebPayload(payload);
            tokenByteOS.write(OBase64Utils.encodeBytesToBytes(bytes, 0, bytes.length, 16));
            byte[] unsignedToken = tokenByteOS.toByteArray();
            tokenByteOS.write(46);
            bytes = this.signToken(header, unsignedToken);
            tokenByteOS.write(OBase64Utils.encodeBytesToBytes(bytes, 0, bytes.length, 16));
        }
        catch (Exception ex) {
            throw new OException("Error on token parsing", ex);
        }
        return tokenByteOS.toByteArray();
    }

    @Override
    public byte[] getSignedBinaryToken(ODatabaseDocumentInternal db, OSecurityUser user, ONetworkProtocolData data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OBinaryToken token = new OBinaryToken();
            long expiryMinutes = this.sessionInMills;
            long currTime = System.currentTimeMillis();
            OrientJwtHeader header = new OrientJwtHeader();
            header.setAlgorithm(algorithm);
            header.setKeyId(algorithm);
            header.setType("OrientDB");
            token.setHeader(header);
            if (db != null) {
                token.setDatabase(db.getName());
                token.setDatabaseType(db.getStorage().getType());
            }
            if (data.serverUser) {
                token.setServerUser(true);
                token.setUserName(data.serverUsername);
            }
            if (user != null) {
                token.setUserRid(user.getIdentity().getIdentity());
            }
            token.setExpiry(currTime + expiryMinutes);
            token.setProtocolVersion(data.protocolVersion);
            token.setSerializer(data.serializationImpl);
            token.setDriverName(data.driverName);
            token.setDriverVersion(data.driverVersion);
            this.binarySerializer.serialize(token, baos);
            byte[] signature = this.signToken(header, baos.toByteArray());
            baos.write(signature);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OException(e);
        }
        return baos.toByteArray();
    }

    @Override
    public ONetworkProtocolData getProtocolDataFromToken(OToken token) {
        if (token instanceof OBinaryToken) {
            OBinaryToken binary = (OBinaryToken)token;
            ONetworkProtocolData data = new ONetworkProtocolData();
            data.protocolVersion = binary.getProtocolVersion();
            data.serializationImpl = binary.getSerializer();
            data.driverName = binary.getDriverName();
            data.driverVersion = binary.getDriverVersion();
            data.serverUser = binary.isServerUser();
            data.serverUsername = binary.getUserName();
            return data;
        }
        return null;
    }

    @Override
    public OToken parseBinaryToken(byte[] binaryToken) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(binaryToken);
            OBinaryToken token = this.deserializeBinaryToken(bais);
            int end = binaryToken.length - bais.available();
            byte[] decodedSignature = new byte[bais.available()];
            bais.read(decodedSignature);
            token.setIsVerified(this.verifyTokenSignature(token.getHeader(), binaryToken, 0, end, decodedSignature));
            return token;
        }
        catch (IOException e) {
            throw new OException(e);
        }
    }

    @Override
    public String getName() {
        return "OTokenHandler";
    }

    @Override
    public byte[] renewIfNeeded(OToken token) {
        if (token == null) {
            throw new IllegalArgumentException("Token is null");
        }
        long curTime = System.currentTimeMillis();
        if (token.getExpiry() + this.sessionInMills / 2L > curTime && token.getExpiry() - (this.sessionInMills + 1L) < curTime) {
            long expiryMinutes = this.sessionInMills;
            long currTime = System.currentTimeMillis();
            token.setExpiry(currTime + expiryMinutes);
        }
        return OCommonConst.EMPTY_BYTE_ARRAY;
    }

    public long getSessionInMills() {
        return this.sessionInMills;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    protected OrientJwtHeader deserializeWebHeader(byte[] decodedHeader) {
        ODocument doc = new ODocument();
        try {
            doc.fromJSON(new String(decodedHeader, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OException(e);
        }
        OrientJwtHeader header = new OrientJwtHeader();
        header.setType((String)doc.field("typ"));
        header.setAlgorithm((String)doc.field("alg"));
        header.setKeyId((String)doc.field("kid"));
        return header;
    }

    protected OJwtPayload deserializeWebPayload(String type, byte[] decodedPayload) {
        if (!"OrientDB".equals(type)) {
            throw new OException("Payload class not registered:" + type);
        }
        ODocument doc = new ODocument();
        try {
            doc.fromJSON(new String(decodedPayload, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OException(e);
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setIssuer((String)doc.field("iss"));
        payload.setExpiry((Long)doc.field("exp"));
        payload.setIssuedAt((Long)doc.field("iat"));
        payload.setNotBefore((Long)doc.field("nbf"));
        payload.setDatabase((String)doc.field("sub"));
        payload.setAudience((String)doc.field("aud"));
        payload.setTokenId((String)doc.field("jti"));
        int cluster = (Integer)doc.field("uidc");
        long pos = (Long)doc.field("uidp");
        payload.setUserRid(new ORecordId(cluster, pos));
        payload.setDatabaseType((String)doc.field("bdtyp"));
        return payload;
    }

    protected byte[] serializeWebHeader(OJwtHeader header) throws Exception {
        if (header == null) {
            throw new IllegalArgumentException("Token header is null");
        }
        ODocument doc = new ODocument();
        doc.field("typ", header.getType());
        doc.field("alg", header.getAlgorithm());
        doc.field("kid", header.getKeyId());
        return doc.toJSON().getBytes("UTF-8");
    }

    protected byte[] serializeWebPayload(OJwtPayload payload) throws Exception {
        if (payload == null) {
            throw new IllegalArgumentException("Token payload is null");
        }
        ODocument doc = new ODocument();
        doc.field("iss", payload.getIssuer());
        doc.field("exp", payload.getExpiry());
        doc.field("iat", payload.getIssuedAt());
        doc.field("nbf", payload.getNotBefore());
        doc.field("sub", payload.getDatabase());
        doc.field("aud", payload.getAudience());
        doc.field("jti", payload.getTokenId());
        doc.field("uidc", ((OrientJwtPayload)payload).getUserRid().getClusterId());
        doc.field("uidp", ((OrientJwtPayload)payload).getUserRid().getClusterPosition());
        doc.field("bdtyp", ((OrientJwtPayload)payload).getDatabaseType());
        return doc.toJSON().getBytes("UTF-8");
    }

    protected OJwtPayload createPayload(ODatabaseDocumentInternal db, OSecurityUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User is null");
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setAudience("OrientDB");
        payload.setDatabase(db.getName());
        payload.setUserRid(user.getDocument().getIdentity());
        long expiryMinutes = this.sessionInMills;
        long currTime = System.currentTimeMillis();
        payload.setIssuedAt(currTime);
        payload.setNotBefore(currTime);
        payload.setUserName(user.getName());
        payload.setTokenId(UUID.randomUUID().toString());
        payload.setExpiry(currTime + expiryMinutes);
        return payload;
    }

    protected String getPayloadType(OJwtPayload payload) {
        return "OrientDB";
    }

    protected OKeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    private boolean verifyTokenSignature(OJwtHeader header, byte[] base, int baseOffset, int baseLength, byte[] signature) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(this.getKeyProvider().getKey(header));
            mac.update(base, baseOffset, baseLength);
            byte[] calculatedSignature = mac.doFinal();
            boolean bl = Arrays.equals(calculatedSignature, signature);
            return bl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OException(e);
        }
        finally {
            mac.reset();
        }
    }

    private byte[] signToken(OrientJwtHeader header, byte[] unsignedToken) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(this.getKeyProvider().getKey(header));
            byte[] byArray = mac.doFinal(unsignedToken);
            return byArray;
        }
        catch (Exception ex) {
            throw new OException("Error on token parsing", ex);
        }
        finally {
            mac.reset();
        }
    }

    private OBinaryToken deserializeBinaryToken(InputStream bais) {
        try {
            return this.binarySerializer.deserialize(bais);
        }
        catch (Exception e) {
            throw new OException(e);
        }
    }

    private static class MacThreadLocal
    extends ThreadLocal<Mac> {
        private MacThreadLocal() {
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new IllegalArgumentException("Can't find encryption algorithm '" + algorithm + "'", nsa);
            }
        }
    }
}

