/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.metadata.security.jwt.OJsonWebToken;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtHeader;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtPayload;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.token.OrientJwtHeader;
import com.orientechnologies.orient.server.token.OrientJwtPayload;

public class JsonWebToken
implements OJsonWebToken,
OToken {
    public final OJwtHeader header;
    public final OJwtPayload payload;
    private boolean isVerified = false;
    private boolean isValid = false;

    public JsonWebToken() {
        this(new OrientJwtHeader(), new OrientJwtPayload());
    }

    public JsonWebToken(OJwtHeader header, OJwtPayload payload) {
        this.header = header;
        this.payload = payload;
    }

    @Override
    public OJwtHeader getHeader() {
        return this.header;
    }

    @Override
    public OJwtPayload getPayload() {
        return this.payload;
    }

    @Override
    public boolean getIsVerified() {
        return this.isVerified;
    }

    @Override
    public void setIsVerified(boolean verified) {
        this.isVerified = verified;
    }

    @Override
    public boolean getIsValid() {
        return this.isValid;
    }

    @Override
    public void setIsValid(boolean valid) {
        this.isValid = valid;
    }

    @Override
    public String getUserName() {
        return this.payload.getUserName();
    }

    @Override
    public String getDatabase() {
        return this.getPayload().getDatabase();
    }

    @Override
    public long getExpiry() {
        return this.getPayload().getExpiry();
    }

    @Override
    public ORID getUserId() {
        return ((OrientJwtPayload)this.payload).getUserRid();
    }

    @Override
    public String getDatabaseType() {
        return this.getPayload().getDatabaseType();
    }

    @Override
    public OUser getUser(ODatabaseDocumentInternal db) {
        ORID userRid = ((OrientJwtPayload)this.payload).getUserRid();
        ODocument result = (ODocument)db.load(userRid, "roles:1");
        if (!result.getSchemaClass().isSubClassOf("OUser")) {
            result = null;
        }
        return new OUser(result);
    }

    @Override
    public void setExpiry(long expiry) {
        this.payload.setExpiry(expiry);
    }
}

