/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class OAsyncCommandResultListener
extends OAbstractCommandResultListener {
    private final ONetworkProtocolBinary protocol;
    private final AtomicBoolean empty = new AtomicBoolean(true);
    private final int txId;
    private final OCommandResultListener resultListener;
    private final Set<ORID> alreadySent = new HashSet<ORID>();

    public OAsyncCommandResultListener(ONetworkProtocolBinary iNetworkProtocolBinary, int txId, OCommandResultListener resultListener) {
        this.protocol = iNetworkProtocolBinary;
        this.txId = txId;
        this.resultListener = resultListener;
    }

    @Override
    public boolean result(Object iRecord) {
        if (this.empty.compareAndSet(true, false)) {
            try {
                this.protocol.sendOk(this.txId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.fetchRecord(iRecord, new ORemoteFetchListener(){

                @Override
                protected void sendRecord(ORecord iLinked) {
                    if (!OAsyncCommandResultListener.this.alreadySent.contains(iLinked.getIdentity())) {
                        OAsyncCommandResultListener.this.alreadySent.add(iLinked.getIdentity());
                        try {
                            if (((OAsyncCommandResultListener)OAsyncCommandResultListener.this).protocol.connection.data.protocolVersion >= 17) {
                                ((OAsyncCommandResultListener)OAsyncCommandResultListener.this).protocol.channel.writeByte((byte)2);
                                OAsyncCommandResultListener.this.protocol.writeIdentifiable(iLinked);
                            }
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Cannot write against channel", (Throwable)e, new Object[0]);
                        }
                    }
                }
            });
            this.alreadySent.add(((OIdentifiable)iRecord).getIdentity());
            this.protocol.channel.writeByte((byte)1);
            this.protocol.writeIdentifiable((OIdentifiable)((OIdentifiable)iRecord).getRecord());
            this.protocol.channel.flush();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public void end() {
        super.end();
        if (this.resultListener != null) {
            this.resultListener.end();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.empty.get();
    }
}

