/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;

public class OScriptTask
extends OAbstractCommandTask {
    private static final long serialVersionUID = 1L;
    protected String text;
    protected Map<Object, Object> params;
    protected OAbstractRemoteTask.RESULT_STRATEGY resultStrategy;

    public OScriptTask() {
    }

    public OScriptTask(OCommandRequestText iCommand) {
        this.text = iCommand.getText();
        this.params = iCommand.getParameters();
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "execute command=%s db=%s", this.text.toString(), database.getName());
        OCommandRequest cmd = database.command(new OCommandScript(this.text));
        Object res = this.params != null ? cmd.execute(this.params) : cmd.execute(new Object[0]);
        return res;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return this.resultStrategy;
    }

    @Override
    public void setResultStrategy(OAbstractRemoteTask.RESULT_STRATEGY resultStrategy) {
        this.resultStrategy = resultStrategy;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.text);
        out.writeObject(this.params);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.text = in.readUTF();
        this.params = (Map)in.readObject();
    }

    @Override
    public String getName() {
        return "script";
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.text + ")";
    }

    @Override
    public String getPayload() {
        return this.text;
    }
}

