/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OCopyDatabaseChunkTask
extends OAbstractReplicatedTask {
    private static final long serialVersionUID = 1L;
    private String fileName;
    private int chunkNum;
    private long offset;

    public OCopyDatabaseChunkTask() {
    }

    public OCopyDatabaseChunkTask(String iFileName, int iChunkNum, long iOffset) {
        this.fileName = iFileName;
        this.chunkNum = iChunkNum;
        this.offset = iOffset;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        File f = new File(this.fileName);
        if (!f.exists()) {
            throw new IllegalArgumentException("File name '" + this.fileName + "' not found");
        }
        ODistributedDatabaseChunk result = new ODistributedDatabaseChunk(0L, f, this.offset, 0x100000);
        ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s...", this.chunkNum, result.offset, OFileUtils.getSizeAsNumber(result.buffer.length));
        if (result.last) {
            iManager.setDatabaseStatus(iManager.getLocalNodeName(), database.getName(), ODistributedServerManager.DB_STATUS.ONLINE);
        }
        return result;
    }

    @Override
    public boolean isRequireNodeOnline() {
        return false;
    }

    @Override
    public OAbstractRemoteTask.RESULT_STRATEGY getResultStrategy() {
        return OAbstractRemoteTask.RESULT_STRATEGY.ANY;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public String getPayload() {
        return null;
    }

    @Override
    public String getName() {
        return "copy_db_chunk";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.fileName);
        out.writeInt(this.chunkNum);
        out.writeLong(this.offset);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fileName = in.readUTF();
        this.chunkNum = in.readInt();
        this.offset = in.readLong();
    }

    @Override
    public boolean isRequiredOpenDatabase() {
        return false;
    }
}

