/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.serialization;

import com.orientechnologies.common.io.OUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.annotation.OAccess;
import com.orientechnologies.orient.core.annotation.OAfterDeserialization;
import com.orientechnologies.orient.core.annotation.OAfterSerialization;
import com.orientechnologies.orient.core.annotation.OBeforeDeserialization;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.annotation.ODocumentInstance;
import com.orientechnologies.orient.core.annotation.OId;
import com.orientechnologies.orient.core.annotation.OVersion;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedMultiValue;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelperManager;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OSimpleVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.fetch.OObjectFetchContext;
import com.orientechnologies.orient.object.fetch.OObjectFetchListener;
import com.orientechnologies.orient.object.serialization.OObjectSerializerContext;
import com.orientechnologies.orient.object.serialization.OObjectSerializerManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OObjectSerializerHelper {
    public static final Class<?>[] callbackAnnotationClasses = new Class[]{OBeforeDeserialization.class, OAfterDeserialization.class, OBeforeSerialization.class, OAfterSerialization.class};
    private static final Class<?>[] NO_ARGS = new Class[0];
    private static final HashMap<String, List<Field>> classes = new HashMap();
    private static final HashMap<String, Method> callbacks = new HashMap();
    private static final HashMap<String, Object> getters = new HashMap();
    private static final HashMap<String, Object> setters = new HashMap();
    private static final HashMap<Class<?>, Field> boundDocumentFields = new HashMap();
    private static final HashMap<Class<?>, Field> fieldIds = new HashMap();
    private static final HashMap<Class<?>, Field> fieldVersions = new HashMap();
    private static final HashMap<Class<?>, List<String>> embeddedFields = new HashMap();
    public static HashMap<Class<?>, OObjectSerializerContext> serializerContexts = new LinkedHashMap();
    public static Class jpaIdClass;
    public static Class jpaVersionClass;
    public static Class jpaAccessClass;
    public static Class jpaEmbeddedClass;
    public static Class jpaTransientClass;
    public static Class jpaOneToOneClass;
    public static Class jpaOneToManyClass;
    public static Class jpaManyToManyClass;

    public static void register() {
        OObjectSerializerHelperManager.getInstance().registerHelper(OObjectSerializerManager.getInstance());
    }

    public static boolean hasField(Object iPojo, String iProperty) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        return getters.get(className + "." + iProperty) != null;
    }

    public static String getDocumentBoundField(Class<?> iClass) {
        OObjectSerializerHelper.getClassFields(iClass);
        Field f = boundDocumentFields.get(iClass);
        return f != null ? f.getName() : null;
    }

    public static Class<?> getFieldType(Object iPojo, String iProperty) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        try {
            Object o = getters.get(className + "." + iProperty);
            if (o == null) {
                return null;
            }
            if (o instanceof Field) {
                return ((Field)o).getType();
            }
            return ((Method)o).getReturnType();
        }
        catch (Exception e) {
            throw new OSchemaException("Cannot get the value of the property: " + iProperty, e);
        }
    }

    public static Class<?> getFieldType(ODocument iDocument, OEntityManager iEntityManager) {
        if (iDocument.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iDocument = (ODocument)iDocument.load();
        }
        if (iDocument.getClassName() == null) {
            return null;
        }
        return iEntityManager.getEntityClass(iDocument.getClassName());
    }

    public static Object getFieldValue(Object iPojo, String iProperty) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        try {
            Object o = getters.get(className + "." + iProperty);
            if (o instanceof Method) {
                return ((Method)o).invoke(iPojo, new Object[0]);
            }
            if (o instanceof Field) {
                return ((Field)o).get(iPojo);
            }
            return null;
        }
        catch (Exception e) {
            throw new OSchemaException("Cannot get the value of the property: " + iProperty, e);
        }
    }

    public static void setFieldValue(Object iPojo, String iProperty, Object iValue) {
        Class<?> c = iPojo.getClass();
        String className = c.getName();
        OObjectSerializerHelper.getClassFields(c);
        try {
            Object o = setters.get(className + "." + iProperty);
            if (o instanceof Method) {
                ((Method)o).invoke(iPojo, OObjectSerializerHelper.convertInObject(iPojo, iProperty, iValue, ((Method)o).getParameterTypes()[0]));
            } else if (o instanceof Field) {
                ((Field)o).set(iPojo, OType.convert(iValue, ((Field)o).getType()));
            }
        }
        catch (Exception e) {
            throw new OSchemaException("Cannot set the value '" + iValue + "' to the property '" + iProperty + "' for the pojo: " + iPojo, e);
        }
    }

    public static Object fromStream(ODocument iRecord, Object iPojo, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler, String iFetchPlan, boolean iLazyLoading) {
        OFetchHelper.checkFetchPlanValid(iFetchPlan);
        long timer = Orient.instance().getProfiler().startChrono();
        Class<?> pojoClass = iPojo.getClass();
        List<Field> properties = OObjectSerializerHelper.getClassFields(pojoClass);
        String idFieldName = OObjectSerializerHelper.setObjectID(iRecord.getIdentity(), iPojo);
        String vFieldName = OObjectSerializerHelper.setObjectVersion(iRecord.getRecordVersion(), iPojo);
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OBeforeDeserialization.class);
        String[] fieldNames = new String[properties.size()];
        int f = 0;
        for (Field p : properties) {
            Object fieldValue;
            String fieldName = p.getName();
            fieldNames[f++] = fieldName;
            if (fieldName.equals(idFieldName) || fieldName.equals(vFieldName) || !iRecord.containsField(fieldName)) continue;
            Object value = fieldValue = iRecord.field(fieldName);
            Object type = null;
            if (fieldValue != null && fieldValue instanceof ODocument && (!(fieldValue instanceof Collection) || ((Collection)fieldValue).size() != 0 && ((Collection)fieldValue).iterator().next() instanceof ODocument) && fieldValue instanceof Map && ((Map)fieldValue).size() != 0 && ((Map)fieldValue).values().iterator().next() instanceof ODocument) continue;
            Class<?> genericTypeClass = OReflectionHelper.getGenericMultivalueType(p);
            if (genericTypeClass != null) {
                Map map;
                Set set;
                HashSet<Object> newColl;
                Object v;
                List list;
                if (genericTypeClass.isEnum()) {
                    if (fieldValue instanceof List) {
                        list = (List)fieldValue;
                        for (int i = 0; i < list.size(); ++i) {
                            v = list.get(i);
                            if (v == null) continue;
                            v = Enum.valueOf(genericTypeClass, v.toString());
                            list.set(i, v);
                        }
                        value = list;
                        type = List.class;
                    } else if (fieldValue instanceof Set) {
                        newColl = new HashSet<Object>();
                        set = (Set)fieldValue;
                        for (Object v2 : set) {
                            if (v2 == null) continue;
                            v2 = Enum.valueOf(genericTypeClass, v2.toString());
                            newColl.add(v2);
                        }
                        value = newColl;
                        type = Set.class;
                    } else if (fieldValue instanceof Map) {
                        map = (Map)fieldValue;
                        for (Map.Entry entry : map.entrySet()) {
                            v = entry.getValue();
                            if (v == null) continue;
                            v = Enum.valueOf(genericTypeClass, v.toString());
                            map.put(entry.getKey(), v);
                        }
                        type = Map.class;
                        value = map;
                    }
                } else if (fieldValue instanceof List) {
                    list = (List)fieldValue;
                    for (int i = 0; i < list.size(); ++i) {
                        v = list.get(i);
                        if (v == null) continue;
                        list.set(i, OObjectSerializerHelper.unserializeFieldValue(genericTypeClass, v));
                    }
                    value = list;
                    type = List.class;
                } else if (fieldValue instanceof Set) {
                    newColl = new HashSet();
                    set = (Set)fieldValue;
                    for (Object v2 : set) {
                        if (v2 == null) continue;
                        newColl.add(OObjectSerializerHelper.unserializeFieldValue(genericTypeClass, v2));
                    }
                    value = newColl;
                    type = Set.class;
                } else if (fieldValue instanceof Map) {
                    map = (Map)fieldValue;
                    for (Map.Entry entry : map.entrySet()) {
                        v = entry.getValue();
                        if (v == null) continue;
                        map.put(entry.getKey(), OObjectSerializerHelper.unserializeFieldValue(genericTypeClass, v));
                    }
                    value = map;
                    type = Map.class;
                }
            }
            if (type == null) {
                type = p.getGenericType();
                value = OObjectSerializerHelper.unserializeFieldValue((Class)(type != null && type instanceof Class ? type : null), fieldValue);
            }
            OObjectSerializerHelper.setFieldValue(iPojo, fieldName, value);
        }
        OObjectFetchListener listener = new OObjectFetchListener();
        OObjectFetchContext context = new OObjectFetchContext(iFetchPlan, iLazyLoading, iEntityManager, iObj2RecHandler);
        OFetchHelper.fetch(iRecord, iPojo, OFetchHelper.buildFetchPlan(iFetchPlan), listener, context, "");
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OAfterDeserialization.class);
        Orient.instance().getProfiler().stopChrono("Object.fromStream", "Deserialize object from stream", timer);
        return iPojo;
    }

    public static String setObjectID(ORID iIdentity, Object iPojo) {
        if (iPojo == null) {
            return null;
        }
        Class<?> pojoClass = iPojo.getClass();
        OObjectSerializerHelper.getClassFields(pojoClass);
        Field idField = fieldIds.get(pojoClass);
        if (idField != null) {
            Class<?> fieldType = idField.getType();
            String idFieldName = idField.getName();
            if (ORID.class.isAssignableFrom(fieldType)) {
                OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity);
            } else if (Number.class.isAssignableFrom(fieldType)) {
                OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity != null ? Long.valueOf(iIdentity.getClusterPosition()) : null);
            } else if (fieldType.equals(String.class)) {
                OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity != null ? iIdentity.toString() : null);
            } else if (fieldType.equals(Object.class)) {
                OObjectSerializerHelper.setFieldValue(iPojo, idFieldName, iIdentity);
            } else {
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Id field has been declared as %s while the supported are: ORID, Number, String, Object", fieldType);
            }
            return idFieldName;
        }
        return null;
    }

    public static ORecordId getObjectID(ODatabasePojoAbstract<?> iDb, Object iPojo) {
        Object id;
        OObjectSerializerHelper.getClassFields(iPojo.getClass());
        Field idField = fieldIds.get(iPojo.getClass());
        if (idField != null && (id = OObjectSerializerHelper.getFieldValue(iPojo, idField.getName())) != null) {
            if (id instanceof ORecordId) {
                return (ORecordId)id;
            }
            if (id instanceof Number) {
                OClass cls = iDb.getMetadata().getSchema().getClass(iPojo.getClass());
                if (cls == null) {
                    throw new OConfigurationException("Class " + iPojo.getClass() + " is not managed by current database");
                }
                return new ORecordId(cls.getDefaultClusterId(), ((Number)id).longValue());
            }
            if (id instanceof String) {
                return new ORecordId((String)id);
            }
        }
        return null;
    }

    public static String getObjectIDFieldName(Object iPojo) {
        OObjectSerializerHelper.getClassFields(iPojo.getClass());
        Field idField = fieldIds.get(iPojo.getClass());
        if (idField != null) {
            return idField.getName();
        }
        return null;
    }

    public static boolean hasObjectID(Object iPojo) {
        OObjectSerializerHelper.getClassFields(iPojo.getClass());
        return fieldIds.get(iPojo.getClass()) != null;
    }

    public static String setObjectVersion(ORecordVersion iVersion, Object iPojo) {
        if (iPojo == null) {
            return null;
        }
        Class<?> pojoClass = iPojo.getClass();
        OObjectSerializerHelper.getClassFields(pojoClass);
        Field vField = fieldVersions.get(pojoClass);
        if (vField != null) {
            Class<?> fieldType = vField.getType();
            String vFieldName = vField.getName();
            if (Number.class.isAssignableFrom(fieldType)) {
                if (iVersion instanceof OSimpleVersion) {
                    OObjectSerializerHelper.setFieldValue(iPojo, vFieldName, iVersion.getCounter());
                } else {
                    OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field can't be declared as Number in distributed mode. Should be one of following: String, Object, ORecordVersion", new Object[0]);
                }
            } else if (fieldType.equals(String.class)) {
                OObjectSerializerHelper.setFieldValue(iPojo, vFieldName, String.valueOf(iVersion));
            } else if (fieldType.equals(Object.class) || ORecordVersion.class.isAssignableFrom(fieldType)) {
                OObjectSerializerHelper.setFieldValue(iPojo, vFieldName, iVersion);
            } else {
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field has been declared as %s while the supported are: Number, String, Object", fieldType);
            }
            return vFieldName;
        }
        return null;
    }

    public static ORecordVersion getObjectVersion(Object iPojo) {
        Object ver;
        ORecordVersion version;
        OObjectSerializerHelper.getClassFields(iPojo.getClass());
        Field idField = fieldVersions.get(iPojo.getClass());
        if (idField != null && (version = OObjectSerializerHelper.convertVersion(ver = OObjectSerializerHelper.getFieldValue(iPojo, idField.getName()))) != null) {
            return version;
        }
        throw new OObjectNotDetachedException("Cannot retrieve the object's VERSION for '" + iPojo + "' because has not been detached");
    }

    private static ORecordVersion convertVersion(Object ver) {
        if (ver != null) {
            if (ver instanceof ORecordVersion) {
                return (ORecordVersion)ver;
            }
            if (ver instanceof Number) {
                ORecordVersion version = OVersionFactory.instance().createVersion();
                if (version instanceof OSimpleVersion) {
                    version.setCounter(((Number)ver).intValue());
                    return version;
                }
            } else {
                if (ver instanceof String) {
                    ORecordVersion version = OVersionFactory.instance().createVersion();
                    version.getSerializer().fromString((String)ver, version);
                    return version;
                }
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Version field has been declared as %s while the supported are: Number, String, Object", ver.getClass());
            }
        }
        return null;
    }

    public static String getObjectVersionFieldName(Object iPojo) {
        OObjectSerializerHelper.getClassFields(iPojo.getClass());
        Field idField = fieldVersions.get(iPojo.getClass());
        if (idField != null) {
            return idField.getName();
        }
        return null;
    }

    public static boolean hasObjectVersion(Object iPojo) {
        OObjectSerializerHelper.getClassFields(iPojo.getClass());
        return fieldVersions.get(iPojo.getClass()) != null;
    }

    public static ODocument toStream(Object iPojo, ODocument iRecord, OEntityManager iEntityManager, OClass schemaClass, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObject db, boolean iSaveOnlyDirty) {
        Object id;
        if (iSaveOnlyDirty && !iRecord.isDirty()) {
            return iRecord;
        }
        long timer = Orient.instance().getProfiler().startChrono();
        Integer identityRecord = System.identityHashCode(iRecord);
        if (((Set)OSerializationThreadLocal.INSTANCE.get()).contains(identityRecord)) {
            return iRecord;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).add(identityRecord);
        Class<?> pojoClass = iPojo.getClass();
        List<Field> properties = OObjectSerializerHelper.getClassFields(pojoClass);
        Field idField = fieldIds.get(pojoClass);
        if (idField != null && (id = OObjectSerializerHelper.getFieldValue(iPojo, idField.getName())) != null) {
            if (id instanceof ORecordId) {
                ORecordInternal.setIdentity(iRecord, (ORecordId)id);
            } else if (id instanceof Number) {
                ((ORecordId)iRecord.getIdentity()).clusterId = schemaClass.getDefaultClusterId();
                ((ORecordId)iRecord.getIdentity()).clusterPosition = ((Number)id).longValue();
            } else if (id instanceof String) {
                ((ORecordId)iRecord.getIdentity()).fromString((String)id);
            } else if (id.getClass().equals(Object.class)) {
                ORecordInternal.setIdentity(iRecord, (ORecordId)id);
            } else {
                OLogManager.instance().warn(OObjectSerializerHelper.class, "@Id field has been declared as %s while the supported are: ORID, Number, String, Object", id.getClass());
            }
        }
        Field vField = fieldVersions.get(pojoClass);
        boolean versionConfigured = false;
        if (vField != null) {
            versionConfigured = true;
            Object ver = OObjectSerializerHelper.getFieldValue(iPojo, vField.getName());
            ORecordVersion version = OObjectSerializerHelper.convertVersion(ver);
            if (version != null) {
                iRecord.getRecordVersion().copyFrom(version);
            }
        }
        if (db.isMVCC() && !versionConfigured && db.getTransaction() instanceof OTransactionOptimistic) {
            throw new OTransactionException("Cannot involve an object of class '" + pojoClass + "' in an Optimistic Transaction commit because it does not define @Version or @OVersion and therefore cannot handle MVCC");
        }
        iRecord.setClassName(schemaClass != null ? schemaClass.getName() : null);
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OBeforeSerialization.class);
        for (Field p : properties) {
            OProperty schemaProperty;
            String fieldName = p.getName();
            if (idField != null && fieldName.equals(idField.getName()) || vField != null && fieldName.equals(vField.getName())) continue;
            Object fieldValue = OObjectSerializerHelper.serializeFieldValue(OObjectSerializerHelper.getFieldType(iPojo, fieldName), OObjectSerializerHelper.getFieldValue(iPojo, fieldName));
            OProperty oProperty = schemaProperty = schemaClass != null ? schemaClass.getProperty(fieldName) : null;
            if (fieldValue != null && OObjectSerializerHelper.isEmbeddedObject(iPojo.getClass(), fieldValue.getClass(), fieldName, iEntityManager)) {
                if (schemaClass == null) {
                    db.getMetadata().getSchema().createClass(iPojo.getClass());
                    iRecord.setClassNameIfExists(iPojo.getClass().getSimpleName());
                }
                if (schemaProperty == null) {
                    OType t = OType.getTypeByClass(fieldValue.getClass());
                    if (t == null) {
                        t = OType.EMBEDDED;
                    }
                    schemaProperty = iRecord.getSchemaClass().createProperty(fieldName, t);
                }
            }
            fieldValue = OObjectSerializerHelper.typeToStream(fieldValue, schemaProperty != null ? schemaProperty.getType() : null, iEntityManager, iObj2RecHandler, db, iRecord, iSaveOnlyDirty);
            iRecord.field(fieldName, fieldValue);
        }
        iObj2RecHandler.registerUserObject(iPojo, iRecord);
        OObjectSerializerHelper.invokeCallback(iPojo, iRecord, OAfterSerialization.class);
        ((Set)OSerializationThreadLocal.INSTANCE.get()).remove(identityRecord);
        Orient.instance().getProfiler().stopChrono("Object.toStream", "Serialize object to stream", timer);
        return iRecord;
    }

    public static Object serializeFieldValue(Class<?> type, Object iFieldValue) {
        for (Class<?> classContext : serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return serializerContexts.get(classContext).serializeFieldValue(type, iFieldValue);
        }
        if (serializerContexts.get(null) != null) {
            return serializerContexts.get(null).serializeFieldValue(type, iFieldValue);
        }
        return iFieldValue;
    }

    public static Object unserializeFieldValue(Class<?> type, Object iFieldValue) {
        for (Class<?> classContext : serializerContexts.keySet()) {
            if (classContext == null || !classContext.isAssignableFrom(type)) continue;
            return serializerContexts.get(classContext).unserializeFieldValue(type, iFieldValue);
        }
        if (serializerContexts.get(null) != null) {
            return serializerContexts.get(null).unserializeFieldValue(type, iFieldValue);
        }
        return iFieldValue;
    }

    private static Object typeToStream(Object iFieldValue, OType iType, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObject db, ODocument iRecord, boolean iSaveOnlyDirty) {
        if (iFieldValue == null) {
            return null;
        }
        if (!OType.isSimpleType(iFieldValue)) {
            Class<?> fieldClass = iFieldValue.getClass();
            if (fieldClass.isArray()) {
                iFieldValue = OObjectSerializerHelper.multiValueToStream(Arrays.asList(iFieldValue), iType, iEntityManager, iObj2RecHandler, db, iRecord, iSaveOnlyDirty);
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectSerializerHelper.multiValueToStream(iFieldValue, iType, iEntityManager, iObj2RecHandler, db, iRecord, iSaveOnlyDirty);
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                iFieldValue = OObjectSerializerHelper.multiValueToStream(iFieldValue, iType, iEntityManager, iObj2RecHandler, db, iRecord, iSaveOnlyDirty);
            } else if (fieldClass.isEnum()) {
                iFieldValue = ((Enum)iFieldValue).name();
            } else if ((fieldClass = iEntityManager.getEntityClass(fieldClass.getSimpleName())) != null) {
                ODocument linkedDocument = (ODocument)iObj2RecHandler.getRecordByUserObject(iFieldValue, true);
                Object pojo = iFieldValue;
                iFieldValue = OObjectSerializerHelper.toStream(pojo, linkedDocument, iEntityManager, linkedDocument.getSchemaClass(), iObj2RecHandler, db, iSaveOnlyDirty);
                iObj2RecHandler.registerUserObject(pojo, linkedDocument);
            } else {
                Object result = OObjectSerializerHelper.serializeFieldValue(null, iFieldValue);
                if (iFieldValue == result) {
                    throw new OSerializationException("Linked type [" + iFieldValue.getClass() + ":" + iFieldValue + "] cannot be serialized because is not part of registered entities. To fix this error register this class");
                }
                iFieldValue = result;
            }
        }
        return iFieldValue;
    }

    private static Object multiValueToStream(Object iMultiValue, OType iType, OEntityManager iEntityManager, OUserObject2RecordHandler iObj2RecHandler, ODatabaseObject db, ODocument iRecord, boolean iSaveOnlyDirty) {
        OType linkedType;
        if (iMultiValue == null) {
            return null;
        }
        Collection sourceValues = iMultiValue instanceof Collection ? (Collection)iMultiValue : ((Map)((Object)iMultiValue)).values();
        if (iType == null) {
            if (sourceValues.size() == 0) {
                return iMultiValue;
            }
            Object firstValue = sourceValues.iterator().next();
            if (firstValue == null) {
                return iMultiValue;
            }
            iType = OType.isSimpleType(firstValue) ? (iMultiValue instanceof List ? OType.EMBEDDEDLIST : (iMultiValue instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDMAP)) : (iMultiValue instanceof List ? OType.LINKLIST : (iMultiValue instanceof Set ? OType.LINKSET : OType.LINKMAP));
        }
        Object result = iMultiValue;
        if (iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.LINKSET)) {
            result = iRecord != null && iType.equals((Object)OType.EMBEDDEDSET) ? new OTrackedSet(iRecord) : new ORecordLazySet(iRecord);
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.LINKLIST)) {
            result = iRecord != null && iType.equals((Object)OType.EMBEDDEDLIST) ? new OTrackedList(iRecord) : new ArrayList();
        }
        if (iType.equals((Object)OType.LINKLIST) || iType.equals((Object)OType.LINKSET) || iType.equals((Object)OType.LINKMAP)) {
            linkedType = OType.LINK;
        } else if (iType.equals((Object)OType.EMBEDDEDLIST) || iType.equals((Object)OType.EMBEDDEDSET) || iType.equals((Object)OType.EMBEDDEDMAP)) {
            linkedType = OType.EMBEDDED;
        } else {
            throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " must be a multi value type (collection or map)");
        }
        if (iMultiValue instanceof Set) {
            for (Object o : sourceValues) {
                ((Collection)result).add(OObjectSerializerHelper.typeToStream(o, linkedType, iEntityManager, iObj2RecHandler, db, null, iSaveOnlyDirty));
            }
        } else if (iMultiValue instanceof List) {
            for (int i = 0; i < sourceValues.size(); ++i) {
                ((List)result).add(OObjectSerializerHelper.typeToStream(((List)sourceValues).get(i), linkedType, iEntityManager, iObj2RecHandler, db, null, iSaveOnlyDirty));
            }
        } else if (iMultiValue instanceof OObjectLazyMap) {
            result = ((OObjectLazyMap)((Object)iMultiValue)).getUnderlying();
        } else {
            result = iRecord != null && iType.equals((Object)OType.EMBEDDEDMAP) ? new OTrackedMap(iRecord) : new HashMap();
            for (Map.Entry entry : ((Map)((Object)iMultiValue)).entrySet()) {
                ((Map)result).put(entry.getKey(), OObjectSerializerHelper.typeToStream(entry.getValue(), linkedType, iEntityManager, iObj2RecHandler, db, null, iSaveOnlyDirty));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getClassFields(Class<?> iClass) {
        if (iClass.getName().startsWith("java.lang")) {
            return null;
        }
        HashMap<String, List<Field>> hashMap = classes;
        synchronized (hashMap) {
            if (classes.containsKey(iClass.getName())) {
                return classes.get(iClass.getName());
            }
            return OObjectSerializerHelper.analyzeClass(iClass);
        }
    }

    public static Type[] getGenericTypes(Object iObject) {
        Class<?> cls;
        if (iObject instanceof OTrackedMultiValue && (cls = ((OTrackedMultiValue)iObject).getGenericClass()) != null) {
            return new Type[]{cls};
        }
        return OReflectionHelper.getGenericTypes(iObject.getClass());
    }

    public static void invokeCallback(Object iPojo, ODocument iDocument, Class<?> iAnnotation) {
        Method m = callbacks.get(iPojo.getClass().getSimpleName() + "." + iAnnotation.getSimpleName());
        if (m != null) {
            try {
                if (m.getParameterTypes().length > 0) {
                    m.invoke(iPojo, iDocument);
                } else {
                    m.invoke(iPojo, new Object[0]);
                }
            }
            catch (Exception e) {
                throw new OConfigurationException("Error on executing user callback '" + m.getName() + "' annotated with '" + iAnnotation.getSimpleName() + "'", e);
            }
        }
    }

    public static void bindSerializerContext(Class<?> iClassContext, OObjectSerializerContext iSerializerContext) {
        serializerContexts.put(iClassContext, iSerializerContext);
    }

    public static void unbindSerializerContext(Class<?> iClassContext) {
        serializerContexts.remove(iClassContext);
    }

    protected static List<Field> analyzeClass(Class<?> iClass) {
        ArrayList<Field> properties = new ArrayList<Field>();
        classes.put(iClass.getName(), properties);
        Class<Object> currentClass = iClass;
        while (currentClass != Object.class) {
            for (Field f : currentClass.getDeclaredFields()) {
                Method m;
                String getterName;
                Object ann;
                int fieldModifier = f.getModifiers();
                if (Modifier.isStatic(fieldModifier) || Modifier.isNative(fieldModifier) || Modifier.isTransient(fieldModifier) || f.getName().equals("this$0") || jpaTransientClass != null && (ann = f.getAnnotation(jpaTransientClass)) != null) continue;
                String fieldName = f.getName();
                Class<?> fieldType = f.getType();
                properties.add(f);
                boolean autoBinding = true;
                if (f.getAnnotation(OAccess.class) == null || f.getAnnotation(OAccess.class).value() == OAccess.OAccessType.PROPERTY) {
                    autoBinding = true;
                } else if (jpaAccessClass != null && (ann = f.getAnnotation(jpaAccessClass)) != null) {
                    autoBinding = true;
                }
                if (f.getAnnotation(ODocumentInstance.class) != null) {
                    boundDocumentFields.put(iClass, f);
                }
                boolean idFound = false;
                if (f.getAnnotation(OId.class) != null) {
                    fieldIds.put(iClass, f);
                    idFound = true;
                } else if (jpaIdClass != null && f.getAnnotation(jpaIdClass) != null) {
                    fieldIds.put(iClass, f);
                    idFound = true;
                }
                if (idFound) {
                    if (fieldType.isPrimitive()) {
                        OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be a literal to manage the Record Id", f.toString());
                    } else if (!ORID.class.isAssignableFrom(fieldType) && fieldType != String.class && fieldType != Object.class && !Number.class.isAssignableFrom(fieldType)) {
                        OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be managed as type: %s", f.toString(), fieldType);
                    }
                }
                boolean vFound = false;
                if (f.getAnnotation(OVersion.class) != null) {
                    fieldVersions.put(iClass, f);
                    vFound = true;
                } else if (jpaVersionClass != null && f.getAnnotation(jpaVersionClass) != null) {
                    fieldVersions.put(iClass, f);
                    vFound = true;
                }
                if (vFound) {
                    if (fieldType.isPrimitive()) {
                        OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be a literal to manage the Version", f.toString());
                    } else if (fieldType != String.class && fieldType != Object.class && !ORecordVersion.class.isAssignableFrom(fieldType) && !Number.class.isAssignableFrom(fieldType)) {
                        OLogManager.instance().warn(OObjectSerializerHelper.class, "Field '%s' cannot be managed as type: %s", f.toString(), fieldType);
                    }
                }
                if (jpaEmbeddedClass != null && f.getAnnotation(jpaEmbeddedClass) != null) {
                    if (embeddedFields.get(iClass) == null) {
                        embeddedFields.put(iClass, new ArrayList());
                    }
                    embeddedFields.get(iClass).add(fieldName);
                }
                if (autoBinding) {
                    try {
                        getterName = "get" + OUtils.camelCase(fieldName);
                        m = currentClass.getMethod(getterName, NO_ARGS);
                        getters.put(iClass.getName() + "." + fieldName, m);
                    }
                    catch (Exception e) {
                        OObjectSerializerHelper.registerFieldGetter(iClass, fieldName, f);
                    }
                } else {
                    OObjectSerializerHelper.registerFieldGetter(iClass, fieldName, f);
                }
                if (autoBinding) {
                    try {
                        getterName = "set" + OUtils.camelCase(fieldName);
                        m = currentClass.getMethod(getterName, f.getType());
                        setters.put(iClass.getName() + "." + fieldName, m);
                    }
                    catch (Exception e) {
                        OObjectSerializerHelper.registerFieldSetter(iClass, fieldName, f);
                    }
                    continue;
                }
                OObjectSerializerHelper.registerFieldSetter(iClass, fieldName, f);
            }
            OObjectSerializerHelper.registerCallbacks(iClass, currentClass);
            if (!(currentClass = currentClass.getSuperclass()).equals(ODocument.class)) continue;
            currentClass = Object.class;
        }
        return properties;
    }

    private static void registerCallbacks(Class<?> iRootClass, Class<?> iCurrentClass) {
        for (Method m : iCurrentClass.getDeclaredMethods()) {
            for (Class<?> annotationClass : callbackAnnotationClasses) {
                if (m.getAnnotation(annotationClass) == null) continue;
                callbacks.put(iRootClass.getSimpleName() + "." + annotationClass.getSimpleName(), m);
            }
        }
    }

    private static void registerFieldSetter(Class<?> iClass, String fieldName, Field f) {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        setters.put(iClass.getName() + "." + fieldName, f);
    }

    private static void registerFieldGetter(Class<?> iClass, String fieldName, Field f) {
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        getters.put(iClass.getName() + "." + fieldName, f);
    }

    private static boolean isEmbeddedObject(Class<?> iPojoClass, Class<?> iFieldClass, String iFieldName, OEntityManager iEntityManager) {
        return embeddedFields.get(iPojoClass) != null && embeddedFields.get(iPojoClass).contains(iFieldName);
    }

    public static Object convertDocumentInType(ODocument oDocument, Class<?> type) {
        Object pojo = null;
        try {
            pojo = type.newInstance();
            List<Field> fields = OObjectSerializerHelper.analyzeClass(type);
            for (Field aField : fields) {
                OObjectSerializerHelper.setFieldFromDocument(oDocument, pojo, aField);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error(null, "Error on converting document in object", (Throwable)e, new Object[0]);
        }
        return pojo;
    }

    private static void setFieldFromDocument(ODocument iDocument, Object iPojo, Field iField) throws Exception {
        String idFieldName = OObjectSerializerHelper.setObjectID(iDocument.getIdentity(), iPojo);
        String vFieldName = OObjectSerializerHelper.setObjectVersion(iDocument.getRecordVersion(), iPojo);
        String fieldName = iField.getName();
        if (!fieldName.equals(idFieldName) && !fieldName.equals(vFieldName) && iDocument.containsField(fieldName)) {
            Class aClass = (Class)iField.getGenericType();
            Object fieldValue = iDocument.field(fieldName);
            Object realValue = OObjectSerializerHelper.getObject(fieldValue, aClass);
            String setterName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            Method m = iPojo.getClass().getMethod(setterName, aClass);
            m.invoke(iPojo, realValue);
        }
    }

    private static Object getObject(Object fieldValue, Class<?> aClass) {
        if (fieldValue instanceof ODocument) {
            return OObjectSerializerHelper.convertDocumentInType((ODocument)fieldValue, aClass);
        }
        return fieldValue;
    }

    public static Object convertInObject(Object iPojo, String iField, Object iValue, Class<?> parameterType) {
        if (!(iValue instanceof OObjectLazyList)) {
            return OType.convert(iValue, parameterType);
        }
        List aSubList = null;
        try {
            Field aField = OObjectSerializerHelper.getField(iPojo, iField);
            Class<?> listClass = aField.getType();
            ParameterizedType aType = (ParameterizedType)aField.getGenericType();
            Class objectClass = (Class)aType.getActualTypeArguments()[0];
            OObjectLazyList aList = (OObjectLazyList)iValue;
            aSubList = listClass.isInterface() ? new ArrayList() : (List)listClass.newInstance();
            for (Object value : aList) {
                if (value instanceof ODocument) {
                    ODocument aDocument = (ODocument)value;
                    aSubList.add(OObjectSerializerHelper.convertDocumentInType(aDocument, objectClass));
                    continue;
                }
                aSubList.add(value);
            }
        }
        catch (Exception e) {
            OLogManager.instance().error(null, "Error on convertInObject()", (Throwable)e, new Object[0]);
        }
        return aSubList;
    }

    private static Field getField(Object iPojo, String iField) {
        List<Field> fields = OObjectSerializerHelper.getClassFields(iPojo.getClass());
        if (fields != null) {
            for (Field f : fields) {
                if (!f.getName().equals(iField)) continue;
                return f;
            }
        }
        return null;
    }

    static {
        try {
            jpaIdClass = Class.forName("javax.persistence.Id");
            jpaVersionClass = Class.forName("javax.persistence.Version");
            jpaEmbeddedClass = Class.forName("javax.persistence.Embedded");
            jpaTransientClass = Class.forName("javax.persistence.Transient");
            jpaOneToOneClass = Class.forName("javax.persistence.OneToOne");
            jpaOneToManyClass = Class.forName("javax.persistence.OneToMany");
            jpaManyToManyClass = Class.forName("javax.persistence.ManyToMany");
            jpaAccessClass = Class.forName("javax.persistence.Access");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

