/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javassist.util.proxy.MethodFilter;

public class OObjectMethodFilter
implements MethodFilter {
    private Map<Method, String> fieldNameCache = new HashMap<Method, String>();
    private Map<Method, Boolean> isSetterCache = new HashMap<Method, Boolean>();
    private Map<Method, Boolean> isGetterCache = new HashMap<Method, Boolean>();

    @Override
    public boolean isHandled(Method m) {
        String fieldName = this.getFieldName(m);
        if (fieldName == null) {
            return false;
        }
        try {
            if (!OObjectEntitySerializer.isClassField(m.getDeclaringClass(), fieldName)) {
                return false;
            }
            return this.isSetterMethod(m) || this.isGetterMethod(m);
        }
        catch (NoSuchFieldException nsfe) {
            OLogManager.instance().warn((Object)this, "Error handling the method %s in class %s", nsfe, m.getName(), m.getDeclaringClass().getName());
            return false;
        }
        catch (SecurityException se) {
            OLogManager.instance().warn((Object)this, "", se, m.getName(), m.getDeclaringClass().getName());
            return false;
        }
    }

    public String getFieldName(Method m) {
        String fieldName = this.fieldNameCache.get(m);
        if (fieldName != null) {
            return fieldName;
        }
        String methodName = m.getName();
        Class<?> clz = m.getDeclaringClass();
        if (methodName.startsWith("get")) {
            fieldName = this.getFieldName(methodName, "get");
        } else if (methodName.startsWith("set")) {
            fieldName = this.getFieldName(methodName, "set");
        } else if (methodName.startsWith("is")) {
            fieldName = this.getFieldName(methodName, "is");
        } else if (this.isScalaClass(clz)) {
            fieldName = this.getScalaFieldName(clz, methodName);
        }
        if (fieldName != null) {
            this.fieldNameCache.put(m, fieldName);
            return fieldName;
        }
        return null;
    }

    protected String getFieldName(String methodName, String prefix) {
        StringBuffer fieldName = new StringBuffer();
        fieldName.append(Character.toLowerCase(methodName.charAt(prefix.length())));
        fieldName.append(methodName.substring(prefix.length() + 1));
        return fieldName.toString();
    }

    public boolean isSetterMethod(Method m) throws SecurityException, NoSuchFieldException {
        Boolean cachedIsSetter = this.isSetterCache.get(m);
        if (cachedIsSetter != null) {
            return cachedIsSetter;
        }
        String methodName = m.getName();
        Class<?> clz = m.getDeclaringClass();
        if (!methodName.startsWith("set") || !this.checkIfFirstCharAfterPrefixIsUpperCase(methodName, "set") || this.isScalaClass(clz) && !methodName.endsWith("_$eq")) {
            this.isSetterCache.put(m, false);
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length != 1) {
            this.isSetterCache.put(m, false);
            return false;
        }
        if (OObjectEntitySerializer.isTransientField(m.getDeclaringClass(), this.getFieldName(m))) {
            this.isSetterCache.put(m, false);
            return false;
        }
        Class<?>[] parameters = m.getParameterTypes();
        Field f = OObjectEntitySerializer.getField(this.getFieldName(m), m.getDeclaringClass());
        if (!f.getType().isAssignableFrom(parameters[0])) {
            OLogManager.instance().warn((Object)this, "Setter method " + m.toString() + " for field " + f.getName() + " in class " + m.getDeclaringClass().toString() + " cannot be bound to proxied instance: parameter class don't match with field type " + f.getType().toString(), new Object[0]);
            this.isSetterCache.put(m, false);
            return false;
        }
        this.isSetterCache.put(m, true);
        return true;
    }

    public boolean isGetterMethod(Method m) throws SecurityException, NoSuchFieldException {
        int prefixLength;
        Boolean cachedIsGetter = this.isGetterCache.get(m);
        if (cachedIsGetter != null) {
            return cachedIsGetter;
        }
        String methodName = m.getName();
        Class<?> clz = m.getDeclaringClass();
        if (methodName.startsWith("get") && this.checkIfFirstCharAfterPrefixIsUpperCase(methodName, "get")) {
            prefixLength = "get".length();
        } else if (methodName.startsWith("is") && this.checkIfFirstCharAfterPrefixIsUpperCase(methodName, "is")) {
            prefixLength = "is".length();
        } else if (this.isScalaClass(clz) && methodName.equals(this.getFieldName(m))) {
            prefixLength = 0;
        } else {
            this.isGetterCache.put(m, false);
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
            this.isGetterCache.put(m, false);
            return false;
        }
        if (methodName.length() <= prefixLength) {
            this.isGetterCache.put(m, false);
            return false;
        }
        boolean isGetter = !OObjectEntitySerializer.isTransientField(m.getDeclaringClass(), this.getFieldName(m));
        this.isGetterCache.put(m, isGetter);
        return isGetter;
    }

    private boolean checkIfFirstCharAfterPrefixIsUpperCase(String methodName, String prefix) {
        return methodName.length() > prefix.length() ? Character.isUpperCase(methodName.charAt(prefix.length())) : false;
    }

    protected boolean isScalaClass(Class<?> clz) {
        Annotation[] annotations;
        for (Annotation a : annotations = OObjectEntitySerializer.getDeclaredAnnotations(clz)) {
            if (!"scala.reflect.ScalaSignature".contains(a.annotationType().getName()) && !"scala.reflect.ScalaLongSignature".contains(a.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    protected String getScalaFieldName(Class<?> clz, String name) {
        Field[] fields;
        for (Field field : fields = clz.getDeclaredFields()) {
            if (name.equals(field.getName() + "_$eq")) {
                return field.getName();
            }
            if (!name.equals(field.getName())) continue;
            return field.getName();
        }
        return null;
    }
}

