/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionConfigurableAbstract;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;

public class OSQLFunctionLabel
extends OSQLFunctionConfigurableAbstract {
    public static final String NAME = "label";

    public OSQLFunctionLabel() {
        super(NAME, 0, 0);
    }

    @Override
    public Object execute(Object iThis, final OIdentifiable iCurrentRecord, final Object iCurrentResult, Object[] iParameters, final OCommandContext iContext) {
        return OGraphCommandExecutorSQLFactory.runWithAnyGraph(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

            @Override
            public Object call(final OrientBaseGraph graph) {
                if (iCurrentResult != null) {
                    return OSQLEngine.foreachRecord(new OCallable<Object, OIdentifiable>(){

                        @Override
                        public Object call(OIdentifiable iArgument) {
                            return OSQLFunctionLabel.this.getLabel(graph, iArgument);
                        }
                    }, iCurrentResult, iContext);
                }
                return OSQLFunctionLabel.this.getLabel(graph, iCurrentRecord);
            }
        });
    }

    private Object getLabel(OrientBaseGraph graph, OIdentifiable iCurrentRecord) {
        ODocument rec = (ODocument)iCurrentRecord.getRecord();
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(rec);
        if (immutableClass.isVertexType()) {
            OrientVertex vertex = graph.getVertex(iCurrentRecord);
            return vertex.getLabel();
        }
        if (immutableClass.isEdgeType()) {
            OrientEdge edge = graph.getEdge(iCurrentRecord);
            return edge.getLabel();
        }
        throw new OCommandExecutionException("Invalid record: is neither a vertex nor an edge. Found class: " + immutableClass);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: label()";
    }
}

