/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.console;

import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.graph.graphml.OGraphMLReader;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.orientechnologies.orient.graph.migration.OGraphMigration;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.orient.OBonsaiTreeRepair;
import com.tinkerpop.blueprints.impls.orient.OGraphRepair;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class OGremlinConsole
extends OConsoleDatabaseApp {
    public OGremlinConsole(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result;
        try {
            boolean tty = false;
            try {
                if (OGremlinConsole.setTerminalToCBreak()) {
                    tty = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            OGremlinConsole console = new OGremlinConsole(args);
            if (tty) {
                console.setReader(new TTYConsoleReader());
            }
            result = console.run();
        }
        finally {
            try {
                OGremlinConsole.stty("echo");
            }
            catch (Exception exception) {}
        }
        System.exit(result);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a GREMLIN script")
    public void gremlin(@ConsoleParameter(name="script-text", description="The script text to execute") String iScriptText) {
        block3: {
            this.checkForDatabase();
            if (iScriptText == null || iScriptText.length() == 0) {
                return;
            }
            this.resetResultSet();
            long start = System.currentTimeMillis();
            try {
                Object result = this.currentDatabase.command(new OCommandGremlin(iScriptText)).execute(new Object[0]);
                float elapsedSeconds = (System.currentTimeMillis() - start) / 1000L;
                this.out.println("\n" + result);
                this.out.printf("\nScript executed in %f sec(s).", Float.valueOf(elapsedSeconds));
            }
            catch (OStorageException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof OCommandExecutorNotFoundException)) break block3;
                this.out.printf("\nError: the GREMLIN command executor is not installed, check your configuration", new Object[0]);
            }
        }
    }

    @Override
    @ConsoleCommand(description="Import a database into the current one", splitInWords=false)
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        String options;
        this.checkForDatabase();
        List<String> items = OStringSerializerHelper.smartSplit(text, ' ', new char[0]);
        String fileName = items.size() <= 0 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        String string = options = fileName != null ? text.substring(items.get(0).length() + items.get(1).length() + 1).trim() : text;
        if (fileName != null && (fileName.endsWith(".graphml") || fileName.endsWith(".xml"))) {
            this.message("\nImporting GRAPHML database from " + fileName + " with options (" + options + ")...", new Object[0]);
            try {
                Map<String, List<String>> opts = this.parseOptions(options);
                OrientGraph g = new OrientGraph(this.currentDatabase);
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                new OGraphMLReader(g).setOptions(opts).inputGraph((Graph)g, fileName);
                g.commit();
                this.currentDatabase.commit();
            }
            catch (ODatabaseImportException e) {
                this.printError(e);
            }
        } else {
            super.importDatabase(text);
        }
    }

    @Override
    @ConsoleCommand(description="Repair database structure")
    public void repairDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        boolean fix_bonsai;
        boolean fix_ridbags;
        boolean fix_links;
        boolean fix_graph;
        this.checkForDatabase();
        boolean bl = fix_graph = iOptions == null || iOptions.contains("--fix-graph");
        if (fix_graph) {
            new OGraphRepair().repair(new OrientGraphNoTx(this.currentDatabase), this);
        }
        boolean bl2 = fix_links = iOptions == null || iOptions.contains("--fix-links");
        if (fix_links) {
            super.repairDatabase(iOptions);
        }
        if (!this.currentDatabase.getURL().startsWith("plocal")) {
            this.message("\n fix-bonsai can be run only on plocal connection \n", new Object[0]);
            return;
        }
        boolean bl3 = fix_ridbags = iOptions == null || iOptions.contains("--fix-ridbags");
        if (fix_ridbags) {
            OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
            repairer.repairDatabaseRidbags(this.currentDatabase, this);
        }
        boolean bl4 = fix_bonsai = iOptions == null || iOptions.contains("--fix-bonsai");
        if (fix_bonsai) {
            OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
            repairer.repairDatabaseRidbags(this.currentDatabase, this);
        }
    }

    @ConsoleCommand(description="Migrates graph from OMVRBTree to ORidBag")
    public void upgradeGraph() {
        OGraphMigration migration = new OGraphMigration(this.getCurrentDatabase(), this);
        migration.execute();
        this.message("Graph has been upgraded.", new Object[0]);
    }

    @Override
    protected void onBefore() {
        super.onBefore();
        this.out.println("\nInstalling extensions for GREMLIN language v." + OGremlinHelper.getEngineVersion());
        OGremlinHelper.global().create();
    }

    @Override
    protected boolean isCollectingCommands(String iLine) {
        return super.isCollectingCommands(iLine) || iLine.startsWith("gremlin");
    }
}

