/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import java.io.IOException;
import java.io.OutputStream;

public class OChannelBinaryOutputStream
extends OutputStream {
    private OChannelBinaryAsynchClient channel;
    private final byte[] buffer;
    private int pos = 0;

    public OChannelBinaryOutputStream(OChannelBinaryAsynchClient channel) {
        this.channel = channel;
        this.buffer = channel.getBuffer();
    }

    @Override
    public void write(int iByte) throws IOException {
        if (this.pos >= this.buffer.length) {
            this.flush(true);
        }
        this.buffer[this.pos++] = (byte)iByte;
    }

    @Override
    public void close() throws IOException {
        this.flush(false);
        this.channel = null;
    }

    @Override
    public void flush() throws IOException {
    }

    private void flush(boolean iContinue) throws IOException {
        this.channel.beginRequest();
        try {
            this.channel.out.writeInt(this.pos);
            if (this.pos > 0) {
                this.channel.out.write(this.buffer, 0, this.pos);
                this.pos = 0;
            }
            this.channel.out.writeByte(iContinue ? 1 : 0);
        }
        finally {
            this.channel.endRequest();
        }
    }
}

