/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;

public class OWALPage {
    public static final long MAGIC_NUMBER = 4207608830L;
    public static final int PAGE_SIZE = 65536;
    public static final int MIN_RECORD_SIZE = 7;
    public static final int CRC_OFFSET = 0;
    public static final int MAGIC_NUMBER_OFFSET = 4;
    private static final int FREE_SPACE_OFFSET = 12;
    public static final int RECORDS_OFFSET = 16;
    private static final int MAX_ENTRY_SIZE = 65520;
    private final ODirectMemoryPointer pagePointer;

    public OWALPage(ODirectMemoryPointer pagePointer, boolean isNew) {
        this.pagePointer = pagePointer;
        if (isNew) {
            OIntegerSerializer.INSTANCE.serializeInDirectMemory(65520, pagePointer, 12L, new Object[0]);
            OLongSerializer.INSTANCE.serializeInDirectMemory(4207608830L, pagePointer, 4L, new Object[0]);
        }
    }

    public ODirectMemoryPointer getPagePointer() {
        return this.pagePointer;
    }

    public int appendRecord(byte[] content, boolean mergeWithNextPage, boolean recordTail) {
        int freePosition;
        int freeSpace = this.getFreeSpace();
        int position = freePosition = 65536 - freeSpace;
        this.pagePointer.setByte(position, mergeWithNextPage ? (byte)1 : 0);
        this.pagePointer.setByte(++position, recordTail ? (byte)1 : 0);
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(content.length, this.pagePointer, ++position, new Object[0]);
        this.pagePointer.set(position += 4, content, 0, content.length);
        position += content.length;
        OIntegerSerializer.INSTANCE.serializeInDirectMemory(freeSpace - 2 - 4 - content.length, this.pagePointer, 12L, new Object[0]);
        return freePosition;
    }

    public byte[] getRecord(int position) {
        int recordSize = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, (long)(position += 2));
        return this.pagePointer.get(position += 4, recordSize);
    }

    public int getSerializedRecordSize(int position) {
        int recordSize = OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, (long)(position + 2));
        return recordSize + 4 + 2;
    }

    public boolean mergeWithNextPage(int position) {
        return this.pagePointer.getByte(position) > 0;
    }

    public boolean recordTail(int position) {
        return this.pagePointer.getByte(position + 1) > 0;
    }

    public boolean isEmpty() {
        return this.getFreeSpace() == 65520;
    }

    public int getFreeSpace() {
        return OIntegerSerializer.INSTANCE.deserializeFromDirectMemory(this.pagePointer, 12L);
    }

    public int getFilledUpTo() {
        return 65536 - this.getFreeSpace();
    }

    public static int calculateSerializedSize(int recordSize) {
        return recordSize + 4 + 2;
    }

    public static int calculateRecordSize(int serializedSize) {
        return serializedSize - 4 - 2;
    }
}

